(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    218411,       5208]*)
(*NotebookOutlinePosition[    219310,       5238]*)
(*  CellTagsIndexPosition[    219266,       5234]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Supply and Demand", "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  " A simple model of the effects of supply and demand on the price of a \
commodity is:\n \n       ",
  StyleBox["dp/dt = k (D - S)\n        \n ",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "where p is the price, S is the supply, D is the demand, and k is a \
positive constant.\n One speaks of seasonal fluctuation in either supply or \
demand of a commodity.  Saying the fluctuation is seasonal implies regular \
repetition which is usually modeled as being periodic.\n To develop such a \
model, one might assume that S = c1 - c2 Cos[",
  "\[Alpha]",
  " t] and that \n D = a - b p[t]."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Clear[a, b, t, c1, c2, P]\)], "Input"],

Cell[CellGroupData[{

Cell["Periodic Supply - Example", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Let D = 10 - 2 p[t] and S = 8 - 2 Cos[12/2Pi] and k = 4/5.  Now find p[t]."],
   "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[{\(demand = 
      a - b\ P[t] /. {a \[Rule] 10, b \[Rule] 2}\), "\n", \(supply = 
      c1 - c2\ Cos[\[Alpha]\ t] /. {c1 \[Rule] 8, 
          c2 \[Rule] 2, \[Alpha] \[Rule] 12\/\(2\ \[Pi]\)}\), "\n", 
    RowBox[{
      RowBox[{"DSolve", "[", 
        RowBox[{
          RowBox[{"{", 
            RowBox[{
              RowBox[{
                RowBox[{
                  SuperscriptBox["P", "\[Prime]",
                    MultilineFunction->None], "[", "t", "]"}], 
                "==", \(k\ \((demand - supply)\)\)}], ",", \(P[0] == 7\)}], 
            "}"}], ",", \(P[t]\), ",", "t"}], "]"}], 
      "/.", \(k \[Rule] 4\/5\)}]}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(10 - 2\ P[t]\)], "Output"],

Cell[BoxData[
    \(8 - 2\ Cos[\(6\ t\)\/\[Pi]]\)], "Output"],

Cell[BoxData[
    \({{P[
            t] \[Rule] \((\[ExponentialE]\^\(\(\(-8\)\ t\)/5\)\ \((108 + \(32\
\ \[Pi]\^2\)\/5 + 
                    9\ \[ExponentialE]\^\(\(8\ t\)/5\)\ Sec[\(3\ \
t\)\/\[Pi]]\^2 + 
                    16\/25\ \[ExponentialE]\^\(\(8\ t\)/5\)\ \[Pi]\^2\ \
Sec[\(3\ t\)\/\[Pi]]\^2 + 
                    9\ \[ExponentialE]\^\(\(8\ t\)/5\)\ Cos[\(6\ t\)\/\[Pi]]\ \
Sec[\(3\ t\)\/\[Pi]]\^2 + 
                    32\/25\ \[ExponentialE]\^\(\(8\ t\)/5\)\ \[Pi]\^2\ \
Cos[\(6\ t\)\/\[Pi]]\ Sec[\(3\ t\)\/\[Pi]]\^2 + 
                    16\/25\ \[ExponentialE]\^\(\(8\ t\)/5\)\ \[Pi]\^2\ \
Cos[\(6\ t\)\/\[Pi]]\^2\ Sec[\(3\ t\)\/\[Pi]]\^2 + 
                    12\/5\ \[ExponentialE]\^\(\(8\ t\)/5\)\ \[Pi]\ Sec[\(3\ t\
\)\/\[Pi]]\^2\ Sin[\(6\ t\)\/\[Pi]] + 
                    12\/5\ \[ExponentialE]\^\(\(8\ t\)/5\)\ \[Pi]\ Cos[\(6\ t\
\)\/\[Pi]]\ Sec[\(3\ t\)\/\[Pi]]\^2\ Sin[\(6\ t\)\/\[Pi]])\))\)/\((2\ \((\(-3\
\)\ \[ImaginaryI] + \(4\ \[Pi]\)\/5)\)\ \((3\ \[ImaginaryI] + \(4\ \
\[Pi]\)\/5)\))\)}}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(price[t_] = 
      P[t] /. %\[LeftDoubleBracket]1\[RightDoubleBracket]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\((\[ExponentialE]\^\(\(\(-8\)\ t\)/5\)\ \((108 + \(32\ \[Pi]\^2\)\/5 + 
              9\ \[ExponentialE]\^\(\(8\ t\)/5\)\ Sec[\(3\ t\)\/\[Pi]]\^2 + 
              16\/25\ \[ExponentialE]\^\(\(8\ t\)/5\)\ \[Pi]\^2\ Sec[\(3\ t\)\
\/\[Pi]]\^2 + 
              9\ \[ExponentialE]\^\(\(8\ t\)/5\)\ Cos[\(6\ t\)\/\[Pi]]\ \
Sec[\(3\ t\)\/\[Pi]]\^2 + 
              32\/25\ \[ExponentialE]\^\(\(8\ t\)/5\)\ \[Pi]\^2\ Cos[\(6\ t\)\
\/\[Pi]]\ Sec[\(3\ t\)\/\[Pi]]\^2 + 
              16\/25\ \[ExponentialE]\^\(\(8\ t\)/5\)\ \[Pi]\^2\ Cos[\(6\ t\)\
\/\[Pi]]\^2\ Sec[\(3\ t\)\/\[Pi]]\^2 + 
              12\/5\ \[ExponentialE]\^\(\(8\ t\)/5\)\ \[Pi]\ Sec[\(3\ t\)\/\
\[Pi]]\^2\ Sin[\(6\ t\)\/\[Pi]] + 
              12\/5\ \[ExponentialE]\^\(\(8\ t\)/5\)\ \[Pi]\ Cos[\(6\ t\)\/\
\[Pi]]\ Sec[\(3\ t\)\/\[Pi]]\^2\ Sin[\(6\ t\)\/\[Pi]])\))\)/\((2\ \((\(-3\)\ \
\[ImaginaryI] + \(4\ \[Pi]\)\/5)\)\ \((3\ \[ImaginaryI] + \(4\ \[Pi]\)\/5)\))\
\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(price[t] /. 
      a1_\ Cos[\[Alpha]_\ t] + 
          a2_\ Sin[\[Alpha]_\ t] \[RuleDelayed] \@\(a1\^2 + a2\^2\)\ Sin[\
\[Alpha]\ t + ArcTan[a2, a1]]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\((\[ExponentialE]\^\(\(\(-8\)\ t\)/5\)\ \((108 + \(32\ \[Pi]\^2\)\/5 + 
              9\ \[ExponentialE]\^\(\(8\ t\)/5\)\ Sec[\(3\ t\)\/\[Pi]]\^2 + 
              16\/25\ \[ExponentialE]\^\(\(8\ t\)/5\)\ \[Pi]\^2\ Sec[\(3\ t\)\
\/\[Pi]]\^2 + 
              32\/25\ \[ExponentialE]\^\(\(8\ t\)/5\)\ \[Pi]\^2\ Cos[\(6\ t\)\
\/\[Pi]]\ Sec[\(3\ t\)\/\[Pi]]\^2 + 
              16\/25\ \[ExponentialE]\^\(\(8\ t\)/5\)\ \[Pi]\^2\ Cos[\(6\ t\)\
\/\[Pi]]\^2\ Sec[\(3\ t\)\/\[Pi]]\^2 + 
              12\/5\ \[ExponentialE]\^\(\(8\ t\)/5\)\ \[Pi]\ Cos[\(6\ t\)\/\
\[Pi]]\ Sec[\(3\ t\)\/\[Pi]]\^2\ Sin[\(6\ t\)\/\[Pi]] + \@\(81\ \
\[ExponentialE]\^\(\(16\ t\)/5\)\ Sec[\(3\ t\)\/\[Pi]]\^4 + 144\/25\ \
\[ExponentialE]\^\(\(16\ t\)/5\)\ \[Pi]\^2\ Sec[\(3\ t\)\/\[Pi]]\^4\)\ \
Sin[\(6\ t\)\/\[Pi] + 
                    ArcTan[12\/5\ \[ExponentialE]\^\(\(8\ t\)/5\)\ \[Pi]\ \
Sec[\(3\ t\)\/\[Pi]]\^2, 
                      9\ \[ExponentialE]\^\(\(8\ t\)/5\)\ Sec[\(3\ \
t\)\/\[Pi]]\^2]])\))\)/\((2\ \((\(-3\)\ \[ImaginaryI] + \(4\ \[Pi]\)\/5)\)\ \
\((3\ \[ImaginaryI] + \(4\ \[Pi]\)\/5)\))\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(% /. {\@p_ \[RuleDelayed] \@Factor[p], 
        ArcTan[r_, u_] \[RuleDelayed] ArcTan[Cancel[r\/u]]}\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\((\[ExponentialE]\^\(\(\(-8\)\ t\)/5\)\ \((108 + \(32\ \[Pi]\^2\)\/5 + 
              9\ \[ExponentialE]\^\(\(8\ t\)/5\)\ Sec[\(3\ t\)\/\[Pi]]\^2 + 
              16\/25\ \[ExponentialE]\^\(\(8\ t\)/5\)\ \[Pi]\^2\ Sec[\(3\ t\)\
\/\[Pi]]\^2 + 
              32\/25\ \[ExponentialE]\^\(\(8\ t\)/5\)\ \[Pi]\^2\ Cos[\(6\ t\)\
\/\[Pi]]\ Sec[\(3\ t\)\/\[Pi]]\^2 + 
              16\/25\ \[ExponentialE]\^\(\(8\ t\)/5\)\ \[Pi]\^2\ Cos[\(6\ t\)\
\/\[Pi]]\^2\ Sec[\(3\ t\)\/\[Pi]]\^2 + 
              12\/5\ \[ExponentialE]\^\(\(8\ t\)/5\)\ \[Pi]\ Cos[\(6\ t\)\/\
\[Pi]]\ Sec[\(3\ t\)\/\[Pi]]\^2\ Sin[\(6\ t\)\/\[Pi]] + 
              3\/5\ \@\(225 + 16\ \[Pi]\^2\)\ \@\(\[ExponentialE]\^\(\(16\ \
t\)/5\)\ Sec[\(3\ t\)\/\[Pi]]\^4\)\ Sin[\(6\ t\)\/\[Pi] + 
                    ArcTan[\(4\ \[Pi]\)\/15]])\))\)/\((2\ \((\(-3\)\ \
\[ImaginaryI] + \(4\ \[Pi]\)\/5)\)\ \((3\ \[ImaginaryI] + \(4\ \[Pi]\)\/5)\))\
\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(p = 
        Plot[{8, 1, supply, price[t]}, {t, 0, 15}, 
          PlotRange \[Rule] {{0, 20}, {0, 10}}, 
          AxesLabel \[Rule] {"\<Time\>", "\<supply/price\>"}, 
          Ticks \[Rule] {{6, 
                12}, {{1, "\<(A-C1)/B\>"}, {8, "\<C1\>"}}}];\)\)], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 0.05 0 0.0618034 [
[.3 -0.0125 -3 -9 ]
[.3 -0.0125 3 0 ]
[.6 -0.0125 -6 -9 ]
[.6 -0.0125 6 0 ]
[1.025 0 0 -6 ]
[1.025 0 28 6 ]
[-0.0125 .0618 -52.0625 -6 ]
[-0.0125 .0618 0 6 ]
[-0.0125 .49443 -16 -6 ]
[-0.0125 .49443 0 6 ]
[0 .64303 -38 0 ]
[0 .64303 38 12 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.3 0 m
.3 .00625 L
s
[(6)] .3 -0.0125 0 1 Mshowa
.6 0 m
.6 .00625 L
s
[(12)] .6 -0.0125 0 1 Mshowa
0 0 m
1 0 L
s
gsave
1.025 0 -61 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Time) show
87.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .0618 m
.00625 .0618 L
s
gsave
-0.0125 .0618 -113.062 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 13.000 moveto
(H) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(A) show
75.062 13.000 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
81.062 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(C1) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
93.062 13.000 moveto
(L) show
99.062 13.000 moveto
(\\220) show
105.062 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(B) show
111.062 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .49443 m
.00625 .49443 L
s
gsave
-0.0125 .49443 -77 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(C1) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
0 .61803 L
s
gsave
0 .64303 -99 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(supply) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
99.000 13.000 moveto
(\\220) show
105.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(price) show
135.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
0 .49443 m
.03043 .49443 L
.06361 .49443 L
.09477 .49443 L
.12474 .49443 L
.15664 .49443 L
.18735 .49443 L
.21998 .49443 L
.25143 .49443 L
.28168 .49443 L
.31386 .49443 L
.34485 .49443 L
.37465 .49443 L
.40637 .49443 L
.43691 .49443 L
.46937 .49443 L
.50064 .49443 L
.53072 .49443 L
.56273 .49443 L
.59354 .49443 L
.62629 .49443 L
.65784 .49443 L
.6882 .49443 L
.72049 .49443 L
.75 .49443 L
s
0 .0618 m
.03043 .0618 L
.06361 .0618 L
.09477 .0618 L
.12474 .0618 L
.15664 .0618 L
.18735 .0618 L
.21998 .0618 L
.25143 .0618 L
.28168 .0618 L
.31386 .0618 L
.34485 .0618 L
.37465 .0618 L
.40637 .0618 L
.43691 .0618 L
.46937 .0618 L
.50064 .0618 L
.53072 .0618 L
.56273 .0618 L
.59354 .0618 L
.62629 .0618 L
.65784 .0618 L
.6882 .0618 L
.72049 .0618 L
.75 .0618 L
s
0 .37082 m
.00093 .3709 L
.00177 .3711 L
.00274 .3715 L
.00366 .37203 L
.00529 .37334 L
.00707 .3753 L
.00902 .37809 L
.01109 .38175 L
.01481 .39008 L
.02224 .41281 L
.03043 .44531 L
.04641 .51922 L
.05523 .55784 L
.05957 .5745 L
.06361 .588 L
.06776 .59959 L
.07153 .60782 L
.07368 .61148 L
.07571 .6142 L
.07676 .61532 L
.07786 .6163 L
.07843 .61672 L
.07906 .61712 L
.0796 .6174 L
.08017 .61765 L
.08119 .61793 L
.08215 .61803 L
.08309 .61797 L
.08396 .61777 L
.08489 .6174 L
.08592 .61682 L
.087 .616 L
.08801 .61505 L
.09154 .61033 L
.09352 .60676 L
.09533 .60291 L
.10305 .58101 L
.11024 .55387 L
.12654 .47951 L
.14129 .41627 L
.14533 .40247 L
.14961 .39026 L
.15327 .38201 L
.15533 .37832 L
.15729 .37548 L
.15833 .37423 L
.15947 .37309 L
.16052 .37224 L
.16147 .37164 L
Mistroke
.16205 .37136 L
.1626 .37114 L
.16318 .37098 L
.16381 .37086 L
.16435 .37082 L
.16493 .37084 L
.16597 .37102 L
.16694 .37136 L
.16798 .37191 L
.16895 .37261 L
.16985 .37339 L
.17203 .37591 L
.1741 .37904 L
.17805 .38702 L
.1817 .39657 L
.18996 .42485 L
.20595 .49598 L
.21377 .53229 L
.22093 .56267 L
.22778 .58701 L
.2314 .59742 L
.23526 .60635 L
.23731 .6101 L
.23916 .61289 L
.24103 .6151 L
.24279 .61663 L
.24375 .61723 L
.24476 .61768 L
.24563 .61792 L
.24659 .61803 L
.24761 .61797 L
.24819 .61785 L
.24871 .61768 L
.24973 .61723 L
.2507 .61662 L
.25256 .615 L
.2543 .61291 L
.25829 .6062 L
.26217 .59718 L
.26636 .58493 L
.28086 .52711 L
.29631 .45523 L
.30449 .42111 L
.30898 .40518 L
.31323 .39254 L
.31728 .38296 L
.31942 .37898 L
.32168 .3756 L
.32359 .37344 L
.32467 .3725 L
Mistroke
.32568 .3718 L
.32661 .37133 L
.32746 .37103 L
.32844 .37085 L
.32937 .37083 L
.33032 .37098 L
.33118 .37125 L
.33217 .37173 L
.3331 .37235 L
.33477 .37382 L
.33656 .37596 L
.33855 .37898 L
.34065 .38289 L
.34441 .39165 L
.35188 .41514 L
.35988 .44737 L
.37433 .51425 L
.38235 .55012 L
.39106 .58313 L
.39506 .59518 L
.3993 .60541 L
.40292 .61185 L
.40498 .61452 L
.40592 .61549 L
.40691 .61636 L
.40792 .61704 L
.40883 .61751 L
.40975 .61784 L
.41062 .618 L
.41163 .61802 L
.41256 .61788 L
.41358 .61754 L
.4141 .6173 L
.41466 .61697 L
.4167 .61535 L
.41784 .61412 L
.41888 .6128 L
.42282 .60613 L
.4264 .59787 L
.4303 .58668 L
.4374 .56128 L
.45423 .4856 L
.46946 .4193 L
.47711 .39421 L
.48142 .38371 L
.48346 .37976 L
.48537 .3767 L
.48719 .37437 L
.48885 .37275 L
.48979 .37205 L
Mistroke
.49069 .37152 L
.49163 .37113 L
.49265 .37088 L
.49358 .37082 L
.49459 .37093 L
.4951 .37106 L
.49565 .37125 L
.49665 .37172 L
.49763 .37237 L
.49857 .37315 L
.50033 .37503 L
.50237 .37788 L
.50429 .38121 L
.50788 .38904 L
.51592 .41352 L
.5304 .47466 L
.54487 .54165 L
.55308 .57459 L
.55709 .58801 L
.56075 .59835 L
.56464 .60711 L
.56642 .61031 L
.56832 .61312 L
.56928 .61431 L
.57034 .61543 L
.57132 .61628 L
.57221 .61692 L
.57326 .61749 L
.57381 .6177 L
.57439 .61787 L
.57537 .61802 L
.57593 .61803 L
.57644 .61799 L
.57748 .61776 L
.57806 .61754 L
.5786 .61729 L
.57959 .61669 L
.58064 .61586 L
.58246 .61397 L
.58446 .61122 L
.58889 .60274 L
.59303 .59201 L
.60122 .56392 L
.609 .53095 L
.62359 .46294 L
.63116 .43019 L
.63921 .40122 L
.64313 .39016 L
.64682 .38188 L
.65013 .37633 L
Mistroke
.65199 .37404 L
.6537 .37246 L
.6547 .37179 L
.65564 .37131 L
.65649 .37102 L
.65741 .37085 L
.65841 .37084 L
.65892 .3709 L
.65948 .37102 L
.66046 .37138 L
.66138 .37187 L
.66226 .37247 L
.66318 .37326 L
.66483 .37504 L
.66661 .37748 L
.66855 .38077 L
.67263 .38969 L
.67699 .40201 L
.68483 .43035 L
.70053 .50121 L
.7088 .53919 L
.71754 .57448 L
.72536 .59864 L
.7275 .60372 L
.7298 .60836 L
.73178 .61167 L
.73395 .6145 L
.73497 .61555 L
.73605 .61647 L
.73698 .61709 L
.738 .61759 L
.73895 .61789 L
.73998 .61803 L
.74095 .61799 L
.74185 .6178 L
.74271 .61747 L
.74352 .61705 L
.74441 .61646 L
.74536 .61566 L
.74729 .61355 L
.74906 .61106 L
.75 .60951 L
Mfstroke
0 .43262 m
.00707 .36991 L
.01481 .31461 L
.03043 .23029 L
.0476 .16033 L
.06361 .10749 L
.07187 .08466 L
.07968 .06638 L
.0867 .05308 L
.09063 .04703 L
.09431 .04233 L
.09789 .03867 L
.10175 .03575 L
.10394 .03456 L
.10502 .0341 L
.10602 .03375 L
.107 .03347 L
.10789 .03327 L
.10888 .03312 L
.10942 .03306 L
.10994 .03303 L
.1109 .03301 L
.11144 .03303 L
.11195 .03306 L
.11298 .03318 L
.11355 .03328 L
.11408 .03339 L
.11604 .03394 L
.11789 .03469 L
.12003 .0358 L
.12201 .03706 L
.1265 .04066 L
.13408 .04876 L
.14119 .05797 L
.15742 .08049 L
.16516 .08981 L
.16938 .09403 L
.17331 .09726 L
.17668 .09944 L
.1784 .10034 L
.18027 .10113 L
.18134 .10149 L
.18232 .10177 L
.18325 .10198 L
.18426 .10216 L
.18517 .10228 L
.18602 .10234 L
.18692 .10236 L
.18788 .10233 L
.18843 .10229 L
Mistroke
.18894 .10224 L
.18989 .1021 L
.19092 .10189 L
.19202 .1016 L
.19402 .10091 L
.19586 .10007 L
.20009 .09746 L
.20456 .09373 L
.21211 .08543 L
.22039 .07418 L
.23707 .04919 L
.24497 .03857 L
.25227 .03062 L
.25593 .0275 L
.25982 .02494 L
.26184 .02393 L
.26373 .02319 L
.26474 .02287 L
.2658 .0226 L
.26636 .02249 L
.26696 .02238 L
.26748 .02231 L
.26803 .02225 L
.26904 .02219 L
.26999 .02218 L
.27092 .02222 L
.27177 .02231 L
.2727 .02245 L
.27371 .02266 L
.27477 .02294 L
.27576 .02326 L
.27923 .02481 L
.28117 .02597 L
.28295 .0272 L
.29074 .03439 L
.29796 .04322 L
.3143 .06721 L
.32196 .07832 L
.33023 .08871 L
.33403 .09265 L
.33803 .0961 L
.34145 .09841 L
.34325 .09937 L
.3452 .10022 L
.34624 .10059 L
.3472 .10087 L
.3481 .10109 L
.34909 .10128 L
.34998 .1014 L
.35081 .10147 L
Mistroke
.35169 .1015 L
.35263 .10148 L
.35365 .1014 L
.35422 .10133 L
.35476 .10125 L
.35574 .10106 L
.35678 .1008 L
.35877 .10012 L
.36058 .09931 L
.36412 .09722 L
.36795 .09422 L
.3749 .08708 L
.3903 .06585 L
.39846 .05355 L
.40721 .04128 L
.41153 .03597 L
.41563 .03159 L
.41961 .02804 L
.4233 .02544 L
.42679 .02365 L
.42855 .023 L
.42957 .02271 L
.43049 .02249 L
.43144 .02232 L
.43244 .02219 L
.43344 .02213 L
.434 .02211 L
.43453 .02212 L
.43549 .02217 L
.43636 .02226 L
.43737 .02242 L
.43832 .02263 L
.4402 .02319 L
.44197 .02389 L
.44598 .02613 L
.44989 .02912 L
.45409 .03313 L
.46863 .05191 L
.48419 .07513 L
.4924 .08602 L
.49691 .09105 L
.50115 .09499 L
.50525 .09798 L
.50756 .09928 L
.50968 .10021 L
.51148 .10081 L
.51249 .10106 L
.51344 .10125 L
.51444 .10139 L
.51536 .10146 L
Mistroke
.51586 .10149 L
.51641 .10149 L
.51741 .10146 L
.51834 .10138 L
.51921 .10125 L
.52017 .10107 L
.52121 .10081 L
.52331 .1001 L
.52524 .09923 L
.52895 .09698 L
.53247 .0942 L
.54002 .08634 L
.54806 .07576 L
.56254 .05416 L
.57064 .04268 L
.57489 .0373 L
.57939 .03232 L
.58334 .02867 L
.58543 .02703 L
.58767 .02552 L
.58972 .02437 L
.5916 .02352 L
.59251 .02318 L
.59349 .02287 L
.59436 .02263 L
.59528 .02243 L
.59623 .02228 L
.59711 .02218 L
.59806 .02212 L
.59909 .02212 L
.59999 .02217 L
.60095 .02227 L
.60185 .02242 L
.60267 .0226 L
.60469 .02319 L
.60688 .02408 L
.61084 .02638 L
.61502 .02967 L
.61945 .03405 L
.62738 .04379 L
.64297 .06672 L
.65721 .08639 L
.66097 .09059 L
.66506 .0945 L
.66897 .09748 L
.67252 .0995 L
.67465 .10039 L
.67562 .10071 L
.67665 .10099 L
.67775 .10122 L
Mistroke
.67877 .10137 L
.67933 .10143 L
.67986 .10146 L
.68043 .10149 L
.68105 .10149 L
.68207 .10145 L
.68265 .1014 L
.68318 .10133 L
.68416 .10117 L
.68519 .10094 L
.68699 .1004 L
.68897 .0996 L
.69285 .09739 L
.69693 .09423 L
.70423 .08668 L
.72066 .06378 L
.75 .02697 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{281.812, 174.188},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004I0000[R000`400?l00000o`00003ooooooolJ
ooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJ
ooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJ
ooooo`00oooooolJooooo`00oooooolJooooo`00oooooolJooooo`00K_ooool3o`0003Cooooo0ol0
0002ooooo`Go0000J_ooool006gooooo00Go0000ooooooooooooooooo`00000dooooo`03o`000?oo
oooooooo00;ooooo00Co0000oooooooooooo0000J_ooool006gooooo00Go0000oooooooooooooooo
o`00000dooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0J_ooool006gooooo1?l0
000eooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0JOooool006gooooo00?o0000
ooooooooool0=_ooool01Ol0003ooooooooooooooooo000000?ooooo00?o0000ooooooooool0J?oo
ool006kooooo00?o0000ooooooooool0=?ooool2o`0000?ooooo00Go0000ooooooooooooooooo`00
001Zooooo`00Koooool2o`0003Gooooo00?o0000ooooooooool00_ooool3o`0006_ooooo003ooooo
oa[ooooo003oooooo`?o00000_ooool5o`000006ooooool0003oooooo`000?oooooo00000_ooool3
o`0000Gooooo003oooooo`7ooooo00?o0000ooooooooool00oooool02ol0003ooooooooooooooooo
0000ooooool0003oooooo`000?oooooo000000Sooooo000foooool;o00002?ooool00ol0003ooooo
ooooo`03ooooo`0:o`000?ooooooooooooooool0003oooooo`000?oooooo0000ooooo`Go00001?oo
ool003Kooooo00?o0000ooooooooool0=oooool00ol0003oooooooooo`0gooooo`03o`000?oooooo
oooo05?ooooo00?o0000ooooooooool00oooool02ol0003ooooooooooooooooo0000ooooool0003o
ooooo`000?oooooo000000?ooooo00?o0000ooooooooool00_ooool003Kooooo00?o0000oooooooo
ool0=oooool00ol0003oooooooooo`0gooooo`03o`000?oooooooooo057ooooo00Ko0000ooooool0
003oooooo`000?ooool3o`0000?ooooo0_l000000ooooooo0000ooooo`02ooooo`?o00001Oooool0
03Kooooo00?o0000ooooooooool0aOooool01Ol0003oooooo`000?oooooo000001Kooooo000foooo
o`03o`000?oooooooooo0<Gooooo1Ol00003ooooo`03o`000?oooooooooo013ooooo000fooooo`03
o`000?oooooooooo02oooooo1Ol0000Kooooo`Go00006oooool4o`0006gooooo000fooooo`03o`00
0?oooooooooo02kooooo0_l00004ooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo00;ooooo0_l0000Iooooo`03o`00
0?oooooooooo04oooooo000fooooo`03o`000?oooooooooo017ooooo1?l0000Hooooo`03o`000?oo
oooooooo00Gooooo00?o0000ooooooooool05Oooool00ol0003oooooooooo`05ooooo`03o`000?oo
oooooooo01Gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Fooooo`03o`000?oo
oooooooo04oooooo0006ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool04_ooool0
0ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool05?ooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool01oooool0
0ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool05Oooool0
0ol0003oooooooooo`1@ooooo`001Oooool00ol0003oooooooooo`0Jooooo`03o`000?oooooooooo
00;ooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo
00Cooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo
01;ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`1Aooooo`001?ooool01?l0003o
ooooooooooooool2o`000004ooooool0003o0000o`0000Sooooo0_l00003ooooo`?o00001Oooool0
0ol0003oooooooooo`02ooooo`04o`000?ooooooooooooooo`Co00001_ooool00ol0003ooooooooo
o`0?ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool04Oooool00ol0003ooooooooo
o`09ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool02_ooool00ol0003ooooooooo
o`0@ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool04_ooool00ol0003ooooooooo
o`1Booooo`001?ooool01Ol0003ooooooooooooooooo000000?ooooo00?o0000ooooooooool01_oo
ool01?l0003oooooooooool00003ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0
0_ooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000Gooooo00?o0000oooooooo
ool03_ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo017ooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00_ooooo00?o0000oooooooo
ool03oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo013ooooo00?o0000oooooooo
ool0Doooool000Cooooo00Co0000oooooooooooooooo1Ol00002ooooo`Co000000?oooooo`000?oo
ool01_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00;ooooo00?o0000oooooooo
ool00_ooool01?l0003oooooooooool00005oooooi;o0000DOooool000Cooooo00?o0000oooooooo
ool00_ooool00ol0003oooooo`000008ooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`03ooooo`04o`000?ooooooooooooooo`?o00001_ooool00ol0
003oooooooooo`0<ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool03_ooool00ol0
003oooooooooo`0>ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool03_ooool00ol0
003oooooooooo`0<ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool03?ooool00ol0
003oooooooooo`1Eooooo`001Oooool01ol0003ooooooooooooooooo0000ooooool000002?ooool0
0ol0003oooooooooo`05ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool01?ooool0
1Ol0003ooooooooooooooooo000000;ooooo00?o0000ooooooooool00oooool00ol0003ooooooooo
o`0<ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool03Oooool00ol0003ooooooooo
o`0>ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool03_ooool00ol0003ooooooooo
o`0;ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool03?ooool00ol0003ooooooooo
o`1Eooooo`001_ooool01Ol0003ooooooooooooooooo000000[ooooo00Co0000oooooooooooo0000
0_ooool2o`0000Cooooo00?o0000ooooooooool01_ooool01?l0003oooooooooool00002ooooo`03
o`000?oooooooooo00?ooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0;ooooo`03
o`000?oooooooooo00_ooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo013ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0@ooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool0E_ooool000Wooooo0_l0000;ooooo`?o0000
0oooool00ol0003oooooooooo`0=ooooo`Co00001_ooool00ol0003oooooooooo`0;ooooo`03o`00
0?oooooooooo00gooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0Aooooo`03o`00
0?oooooooooo00Wooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`08ooooo`03o`00
0?oooooooooo01;ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`1Gooooo`00=_oo
ool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool04ooo
ool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool01_oo
ool00ol0003oooooooooo`1Hooooo`00=_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooo
oooo00oooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0Dooooo`;o00001_ooool0
0ol0003oooooooooo`0Eooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool05Oooool0
0ol0003oooooooooo`05ooooo`03o`000?oooooooooo05Sooooo000fooooo`03o`000?oooooooooo
00[ooooo00?o0000ooooooooool04Oooool2o`0000Cooooo0_l0000Hooooo`;o00000oooool2o`00
01Wooooo0_l00003ooooo`;o00006Oooool00ol0003oooooooooo`02ooooo`;o0000Foooool003Ko
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0Booooo`Go00006oooool5o`0001_o
oooo1Ol0000Kooooo`Co0000GOooool003Kooooo00?o0000ooooooooool02Oooool00ol0003ooooo
ooooo`3Dooooo`00=_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo0=Cooooo000f
ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0e?ooool003Kooooo00?o0000oooo
ooooool02?ooool00ol0003oooooooooo`3Eooooo`00=_ooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo0=Gooooo000fooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
eOooool003Kooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`3Fooooo`00=_ooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo0=Kooooo000fooooo`03o`000?oooooooooo
00Oooooo00?o0000ooooooooool0e_ooool003Kooooo00?o0000ooooooooool01_ooool00ol0003o
ooooooooo`3Gooooo`00=_ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo0=Oooooo
000fooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0eoooool003Kooooo00?o0000
ooooooooool01_ooool00ol0003oooooooooo`3Gooooo`00=_ooool00ol0003oooooooooo`05oooo
o`03o`000?oooooooooo0=Sooooo000fooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool0f?ooool003Kooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`3Hooooo`00=_oo
ool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo0=Sooooo000fooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool0f?ooool003Kooooo00?o0000ooooooooool01?ooool00ol0
003oooooooooo`3Iooooo`00=_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo0=Wo
oooo000fooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0fOooool003Kooooo00?o
0000ooooooooool01?ooool00ol0003oooooooooo`3Iooooo`00=_ooool00ol0003oooooooooo`04
ooooo`03o`000?oooooooooo0=Wooooo000fooooo`03o`000?oooooooooo00?ooooo00?o0000oooo
ooooool0f_ooool003Kooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`3Jooooo`00
=_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo0=[ooooo000fooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool0f_ooool003Kooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`3Jooooo`00=_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo
0=_ooooo000fooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0foooool003Kooooo
00?o0000ooooooooool00_ooool00ol0003oooooooooo`3Kooooo`00=_ooool00ol0003ooooooooo
o`02ooooo`03o`000?oooooooooo0=_ooooo000fooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool0foooool003Kooooo00Go0000ooooooooooooooooo`00003Nooooo`00=_ooool01Ol0
003ooooooooooooooooo00000=kooooo000fooooo`05o`000?ooooooooooooooool00000g_ooool0
03Kooooo00Go0000ooooooooooooooooo`00003Nooooo`00=_ooool01Ol0003ooooooooooooooooo
00000=kooooo000fooooo`04o`000?ooooooooooo`000=oooooo000fooooo`04o`000?oooooooooo
o`000=oooooo000fooooo`04o`000?ooooooooooo`000=oooooo000fooooo`04o`000?oooooooooo
o`000=oooooo000fooooo`04o`000?ooooooooooo`000=oooooo000fooooo`04o`000?oooooooooo
o`000=oooooo000fooooo`03o`000?oooooo00000>3ooooo000fooooo`03o`000?oooooo00000>3o
oooo000fooooo`03o`000?oooooo00000>3ooooo000fooooo`03o`000?oooooo00000>3ooooo000f
ooooo`03o`000?oooooo00000>3ooooo000fooooo`;o0000hOooool003Kooooo0_l0003Qooooo`00
=_ooool2o`0001gooooo0_l0000Nooooo`;o00007_ooool2o`0001gooooo0ol0001Rooooo`00=_oo
ool2o`0001cooooo0_l000000ooooooo0000ooooo`0Kooooo`;o000000?oooooo`000?ooool06ooo
ool4o`0001cooooo00Co0000ooooool0003o0000HOooool003Kooooo0ol0000Kooooo`05o`000?oo
ooooooooooooool000006oooool00ol0003oooooooooo`02o`0001_ooooo00?o0000ooooooooool0
0_l0000Jooooo`05o`000?ooooooooooooooool00000HOooool003Kooooo0ol0000Kooooo`05o`00
0?ooooooooooooooool000006_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo01So
oooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Hooooo`05o`000?oooooooooooooo
ool00000HOooool003Kooooo0_l000000ooooooo0000ooooo`0Hooooo`03o`000?oooooooooo00;o
oooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo01Oo
oooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo00?o
oooo00?o0000ooooooooool0G_ooool003Kooooo0_l000000ooooooo0000ooooo`0Hooooo`03o`00
0?oooooooooo00?ooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`03ooooo`03o`00
0?oooooooooo01Kooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Gooooo`03o`00
0?oooooooooo00?ooooo00?o0000ooooooooool0G_ooool003Kooooo0_l000000ooooooo0000oooo
o`0Gooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool05_ooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo01Kooooo00?o0000ooooooooool01?ooool00ol0003ooooooooo
o`0Fooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0GOooool003Kooooo00Go0000
ooooooooooooooooo`00000Gooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool05Ooo
ool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo01Gooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0GOoo
ool003Kooooo00Go0000ooooooooooooooooo`00000Fooooo`03o`000?oooooooooo00Kooooo00?o
0000ooooooooool05Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo01Cooooo00?o
0000ooooooooool01_ooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo00Gooooo00?o
0000ooooooooool0GOooool003Kooooo00Go0000ooooooooooooooooo`00000Fooooo`03o`000?oo
oooooooo00Kooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`06ooooo`03o`000?oo
oooooooo01Cooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0Dooooo`03o`000?oo
oooooooo00Gooooo00?o0000ooooooooool0GOooool003Kooooo00Go0000ooooooooooooooooo`00
000Fooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool04oooool00ol0003ooooooooo
o`06ooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool01_ooool00ol0003ooooooooo
o`0Dooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0G?ooool003Kooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool04oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo01?ooooo00?o0000
ooooooooool01oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool0G?ooool003Kooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Boooo
o`03o`000?oooooooooo00Sooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`08oooo
o`03o`000?oooooooooo01?ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0Boooo
o`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0G?ooool003Kooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool04_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo01;ooooo00?o0000oooooooo
ool02?ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00Oooooo00?o0000oooooooo
ool0G?ooool003Kooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Aooooo`03o`00
0?oooooooooo00Wooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`09ooooo`03o`00
0?oooooooooo017ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0Booooo`03o`00
0?oooooooooo00Oooooo00?o0000ooooooooool0G?ooool003Kooooo00?o0000ooooooooool00ooo
ool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool04?oo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool02Ooo
ool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0Fooo
ool003Kooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooo
oooo00[ooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooo
oooo017ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooo
oooo00Wooooo00?o0000ooooooooool0Foooool003Kooooo00?o0000ooooooooool00oooool00ol0
003oooooooooo`0@ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool04?ooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool02_ooool00ol0
003oooooooooo`0@ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0Foooool003Ko
oooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00_o
oooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo013o
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool0F_ooool003Kooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`0?ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool03_ooool00ol0003ooooo
ooooo`0<ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool02oooool00ol0003ooooo
ooooo`0?ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool0F_ooool003Kooooo00?o
0000ooooooooool01?ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00cooooo00?o
0000ooooooooool03_ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00oooooo00?o
0000ooooooooool02oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool0F_ooool003Kooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0>
ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0<
ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0>
ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool0FOooool002Sooooo0_l00003oooo
o`?o00001_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00kooooo00?o0000oooo
ooooool03?ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00cooooo00?o0000oooo
ooooool03_ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00kooooo00?o0000oooo
ooooool03?ooool00ol0003oooooooooo`1Iooooo`009oooool01?l0003oooooooooool00003oooo
o`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0=oooo
o`03o`000?oooooooooo00gooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0<oooo
o`03o`000?oooooooooo00kooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0>oooo
o`03o`000?oooooooooo00cooooo00?o0000ooooooooool0FOooool002Kooooo00?o0000oooooooo
ool01Oooool00ol0003oooooooooo`05oooooi;o0000DOooool002Kooooo00?o0000ooooooooool0
1Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0
3?ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool0
3Oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool0
3?ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo05Sooooo000Vooooo`03o`000?oo
oooooooo00Gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`05ooooo`03o`000?oo
oooooooo00cooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0<ooooo`03o`000?oo
oooooooo00kooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0>ooooo`03o`000?oo
oooooooo00cooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`1Hooooo`009oooool0
1?l0003oooooooooool00002ooooo`;o00001oooool00ol0003oooooooooo`05ooooo`03o`000?oo
oooooooo00cooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0<ooooo`03o`000?oo
oooooooo00kooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0>ooooo`03o`000?oo
oooooooo00cooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`1Hooooo`00:?ooool3
o`0000?ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooo
oooo00_ooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooo
oooo00kooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooo
oooo00cooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`1Hooooo`00=_ooool00ol0
003oooooooooo`06ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool04?ooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool03?ooool00ol0
003oooooooooo`0>ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool03_ooool00ol0
003oooooooooo`1Hooooo`00=_ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00[o
oooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00oo
oooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00_o
oooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`1Gooooo`00=_ooool00ol0003ooooo
ooooo`06ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool04?ooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`0@ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool04?ooool00ol0003ooooo
ooooo`1Gooooo`00=_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Wooooo00?o
0000ooooooooool04?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo013ooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool04?ooool00ol0003oooooooooo`1Gooooo`00=_ooool00ol0003oooooooooo`07
ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`09
ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0@
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`1G
ooooo`00=_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool04_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo01;ooooo00?o0000oooo
ooooool02Oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00Wooooo00?o0000oooo
ooooool04Oooool00ol0003oooooooooo`1Gooooo`00=_ooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo01;ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0Aooooo`03
o`000?oooooooooo00Wooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`1Gooooo`00
=_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0
4oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
4_ooool00ol0003oooooooooo`1Fooooo`00=_ooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo01?ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0Booooo`03o`000?oo
oooooooo00Oooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`1Fooooo`00=_ooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool04oooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool01oooool0
0ol0003oooooooooo`0Booooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool04oooool0
0ol0003oooooooooo`1Fooooo`00=_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
01?ooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo
00Kooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`1Eooooo`00=_ooool00ol0003o
ooooooooo`09ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool05Oooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo01Gooooo00?o0000ooooooooool01Oooool00ol0003o
ooooooooo`0Dooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool05?ooool00ol0003o
ooooooooo`1Eooooo`00=_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Gooooo
00?o0000ooooooooool05Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo01Gooooo
00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo00Gooooo
00?o0000ooooooooool05Oooool00ol0003oooooooooo`1Eooooo`00=_ooool00ol0003ooooooooo
o`09ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool05Oooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo01Gooooo00?o0000ooooooooool01?ooool00ol0003ooooooooo
o`0Fooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool05Oooool00ol0003ooooooooo
o`1Eooooo`00=_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool05_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo01Gooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool05_ooool00ol0003oooooooooo`1Dooooo`00=_ooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00?ooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`03oooo
o`03o`000?oooooooooo01Kooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Goooo
o`03o`000?oooooooooo00Cooooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`1Doooo
o`00=_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00;ooooo00?o0000oooooooo
ool06?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo01Kooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo00?ooooo00?o0000oooooooo
ool06?ooool00ol0003oooooooooo`1Cooooo`00=_ooool00ol0003oooooooooo`0;ooooo`05o`00
0?ooooooooooooooool000006oooool01Ol0003ooooooooooooooooo000001[ooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`0Hooooo`;o00000oooool00ol0003oooooooooo`0Hoooo
o`05o`000?ooooooooooooooool00000DOooool003Kooooo00?o0000ooooooooool02oooool2o`00
0003ooooool0003ooooo01_ooooo0_l000000ooooooo0000ooooo`0Kooooo`;o000000?oooooo`00
0?ooool06oooool01?l0003oooooooooool0000Looooo`04o`000?ooooooooooo`00057ooooo000f
ooooo`03o`000?oooooooooo00cooooo0ol0000Mooooo`;o00007_ooool2o`0001kooooo0_l0000M
ooooo`?o0000D_ooool00?oooooo6_ooool00?oooooo6_ooool00?oooooo6_ooool00?oooooo6_oo
ool00?oooooo6_ooool00?oooooo6_ooool001kooooo0ol00003ooooo`?o00002Oooool3o`0000Wo
oooo0ol0003Jooooo`007oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Wooooo
00?o0000ooooooooool00oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo0=Wooooo
000Booooo`Co00001?ooool2o`000003ooooool0003ooooo00?o00000oooool3o`0000;ooooo1Ol0
0003ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool3o`0000;ooooo0ol0
0003ooooo`Go00000_ooool3o`0000?ooooo0ol00031ooooo`005_ooool01?l0003oooooooooool0
0002ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000_ooool01Ol0003o
oooooooooooooooo000000Gooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`02oooo
o`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool01?ooool01Ol0003ooooooooooooo
oooo000000?ooooo00?o0000ooooool00000a?ooool001?ooooo0ol00003ooooo`04o`000?oooooo
ooooo`0000;ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00003ooooo`03
o`000?oooooooooo00;ooooo00?o0000ooooool000001?ooool00ol0003oooooooooo`02ooooo`04
o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool01?ooool01Ol0003ooooooooooooooooo
000000Gooooo1Ol00030ooooo`004_ooool00ol0003oooooooooo`04ooooo`04o`000?oooooooooo
o`0000;ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00003ooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooool000001Oooool01Ol0003ooooooooooooooooo000000;o
oooo00?o0000ooooooooool00_l00005ooooo`05o`000?ooooooooooooooool000000oooool00ol0
003oooooo`000003ooooo`03o`000?oooooooooo0;kooooo000Cooooo`Co000000Coooooo`000?l0
003ooooo0_l000000ooooooo0000o`000002o`0000;ooooo1?l00004ooooo`04o`000?oooooooooo
ooooo`;o000000?oooooo`000?l000001?ooool00ol0003oooooooooo`04o`0000;ooooo0_l00000
1?oooooo0000o`000?ooool3o`0000Cooooo0ol00003ooooo`?o0000`Oooool002cooooo00?o0000
ooooooooool02oooool00ol0003oooooooooo`3Looooo`00:_ooool3o`0001gooooo00?o0000oooo
ooooool0c?ooool00?oooooo6_ooool00?oooooo6_ooool00?oooooo6_ooool00?oooooo6_ooool0
0?oooooo6_ooool00?oooooo6_ooool00?oooooo6_ooool00?oooooo6_ooool00?oooooo6_ooool0
0?oooooo6_ooool00?oooooo6_ooool00?oooooo6_ooool00?oooooo6_ooool00?oooooo6_ooool0
0001\
\>"],
  ImageRangeCache->{{{0, 280.812}, {173.188, 0}} -> {-5.63146, -2.01468, \
0.103363, 0.0836228}}]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(Show[p, 
        Graphics[Text["\<supply\>", {16, 8}, {\(-1\), 0}], 
          Text["\<price\>", {16, 1}, {\(-1\), 0}]]];\)\)], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 0.05 0 0.0618034 [
[.3 -0.0125 -3 -9 ]
[.3 -0.0125 3 0 ]
[.6 -0.0125 -6 -9 ]
[.6 -0.0125 6 0 ]
[1.025 0 0 -6 ]
[1.025 0 28 6 ]
[-0.0125 .0618 -52.0625 -6 ]
[-0.0125 .0618 0 6 ]
[-0.0125 .49443 -16 -6 ]
[-0.0125 .49443 0 6 ]
[0 .64303 -38 0 ]
[0 .64303 38 12 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.3 0 m
.3 .00625 L
s
[(6)] .3 -0.0125 0 1 Mshowa
.6 0 m
.6 .00625 L
s
[(12)] .6 -0.0125 0 1 Mshowa
0 0 m
1 0 L
s
gsave
1.025 0 -61 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Time) show
87.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .0618 m
.00625 .0618 L
s
gsave
-0.0125 .0618 -113.062 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 13.000 moveto
(H) show
69.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(A) show
75.062 13.000 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
81.062 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(C1) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
93.062 13.000 moveto
(L) show
99.062 13.000 moveto
(\\220) show
105.062 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(B) show
111.062 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .49443 m
.00625 .49443 L
s
gsave
-0.0125 .49443 -77 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(C1) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
0 .61803 L
s
gsave
0 .64303 -99 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(supply) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
99.000 13.000 moveto
(\\220) show
105.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(price) show
135.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
0 .49443 m
.03043 .49443 L
.06361 .49443 L
.09477 .49443 L
.12474 .49443 L
.15664 .49443 L
.18735 .49443 L
.21998 .49443 L
.25143 .49443 L
.28168 .49443 L
.31386 .49443 L
.34485 .49443 L
.37465 .49443 L
.40637 .49443 L
.43691 .49443 L
.46937 .49443 L
.50064 .49443 L
.53072 .49443 L
.56273 .49443 L
.59354 .49443 L
.62629 .49443 L
.65784 .49443 L
.6882 .49443 L
.72049 .49443 L
.75 .49443 L
s
0 .0618 m
.03043 .0618 L
.06361 .0618 L
.09477 .0618 L
.12474 .0618 L
.15664 .0618 L
.18735 .0618 L
.21998 .0618 L
.25143 .0618 L
.28168 .0618 L
.31386 .0618 L
.34485 .0618 L
.37465 .0618 L
.40637 .0618 L
.43691 .0618 L
.46937 .0618 L
.50064 .0618 L
.53072 .0618 L
.56273 .0618 L
.59354 .0618 L
.62629 .0618 L
.65784 .0618 L
.6882 .0618 L
.72049 .0618 L
.75 .0618 L
s
0 .37082 m
.00093 .3709 L
.00177 .3711 L
.00274 .3715 L
.00366 .37203 L
.00529 .37334 L
.00707 .3753 L
.00902 .37809 L
.01109 .38175 L
.01481 .39008 L
.02224 .41281 L
.03043 .44531 L
.04641 .51922 L
.05523 .55784 L
.05957 .5745 L
.06361 .588 L
.06776 .59959 L
.07153 .60782 L
.07368 .61148 L
.07571 .6142 L
.07676 .61532 L
.07786 .6163 L
.07843 .61672 L
.07906 .61712 L
.0796 .6174 L
.08017 .61765 L
.08119 .61793 L
.08215 .61803 L
.08309 .61797 L
.08396 .61777 L
.08489 .6174 L
.08592 .61682 L
.087 .616 L
.08801 .61505 L
.09154 .61033 L
.09352 .60676 L
.09533 .60291 L
.10305 .58101 L
.11024 .55387 L
.12654 .47951 L
.14129 .41627 L
.14533 .40247 L
.14961 .39026 L
.15327 .38201 L
.15533 .37832 L
.15729 .37548 L
.15833 .37423 L
.15947 .37309 L
.16052 .37224 L
.16147 .37164 L
Mistroke
.16205 .37136 L
.1626 .37114 L
.16318 .37098 L
.16381 .37086 L
.16435 .37082 L
.16493 .37084 L
.16597 .37102 L
.16694 .37136 L
.16798 .37191 L
.16895 .37261 L
.16985 .37339 L
.17203 .37591 L
.1741 .37904 L
.17805 .38702 L
.1817 .39657 L
.18996 .42485 L
.20595 .49598 L
.21377 .53229 L
.22093 .56267 L
.22778 .58701 L
.2314 .59742 L
.23526 .60635 L
.23731 .6101 L
.23916 .61289 L
.24103 .6151 L
.24279 .61663 L
.24375 .61723 L
.24476 .61768 L
.24563 .61792 L
.24659 .61803 L
.24761 .61797 L
.24819 .61785 L
.24871 .61768 L
.24973 .61723 L
.2507 .61662 L
.25256 .615 L
.2543 .61291 L
.25829 .6062 L
.26217 .59718 L
.26636 .58493 L
.28086 .52711 L
.29631 .45523 L
.30449 .42111 L
.30898 .40518 L
.31323 .39254 L
.31728 .38296 L
.31942 .37898 L
.32168 .3756 L
.32359 .37344 L
.32467 .3725 L
Mistroke
.32568 .3718 L
.32661 .37133 L
.32746 .37103 L
.32844 .37085 L
.32937 .37083 L
.33032 .37098 L
.33118 .37125 L
.33217 .37173 L
.3331 .37235 L
.33477 .37382 L
.33656 .37596 L
.33855 .37898 L
.34065 .38289 L
.34441 .39165 L
.35188 .41514 L
.35988 .44737 L
.37433 .51425 L
.38235 .55012 L
.39106 .58313 L
.39506 .59518 L
.3993 .60541 L
.40292 .61185 L
.40498 .61452 L
.40592 .61549 L
.40691 .61636 L
.40792 .61704 L
.40883 .61751 L
.40975 .61784 L
.41062 .618 L
.41163 .61802 L
.41256 .61788 L
.41358 .61754 L
.4141 .6173 L
.41466 .61697 L
.4167 .61535 L
.41784 .61412 L
.41888 .6128 L
.42282 .60613 L
.4264 .59787 L
.4303 .58668 L
.4374 .56128 L
.45423 .4856 L
.46946 .4193 L
.47711 .39421 L
.48142 .38371 L
.48346 .37976 L
.48537 .3767 L
.48719 .37437 L
.48885 .37275 L
.48979 .37205 L
Mistroke
.49069 .37152 L
.49163 .37113 L
.49265 .37088 L
.49358 .37082 L
.49459 .37093 L
.4951 .37106 L
.49565 .37125 L
.49665 .37172 L
.49763 .37237 L
.49857 .37315 L
.50033 .37503 L
.50237 .37788 L
.50429 .38121 L
.50788 .38904 L
.51592 .41352 L
.5304 .47466 L
.54487 .54165 L
.55308 .57459 L
.55709 .58801 L
.56075 .59835 L
.56464 .60711 L
.56642 .61031 L
.56832 .61312 L
.56928 .61431 L
.57034 .61543 L
.57132 .61628 L
.57221 .61692 L
.57326 .61749 L
.57381 .6177 L
.57439 .61787 L
.57537 .61802 L
.57593 .61803 L
.57644 .61799 L
.57748 .61776 L
.57806 .61754 L
.5786 .61729 L
.57959 .61669 L
.58064 .61586 L
.58246 .61397 L
.58446 .61122 L
.58889 .60274 L
.59303 .59201 L
.60122 .56392 L
.609 .53095 L
.62359 .46294 L
.63116 .43019 L
.63921 .40122 L
.64313 .39016 L
.64682 .38188 L
.65013 .37633 L
Mistroke
.65199 .37404 L
.6537 .37246 L
.6547 .37179 L
.65564 .37131 L
.65649 .37102 L
.65741 .37085 L
.65841 .37084 L
.65892 .3709 L
.65948 .37102 L
.66046 .37138 L
.66138 .37187 L
.66226 .37247 L
.66318 .37326 L
.66483 .37504 L
.66661 .37748 L
.66855 .38077 L
.67263 .38969 L
.67699 .40201 L
.68483 .43035 L
.70053 .50121 L
.7088 .53919 L
.71754 .57448 L
.72536 .59864 L
.7275 .60372 L
.7298 .60836 L
.73178 .61167 L
.73395 .6145 L
.73497 .61555 L
.73605 .61647 L
.73698 .61709 L
.738 .61759 L
.73895 .61789 L
.73998 .61803 L
.74095 .61799 L
.74185 .6178 L
.74271 .61747 L
.74352 .61705 L
.74441 .61646 L
.74536 .61566 L
.74729 .61355 L
.74906 .61106 L
.75 .60951 L
Mfstroke
0 .43262 m
.00707 .36991 L
.01481 .31461 L
.03043 .23029 L
.0476 .16033 L
.06361 .10749 L
.07187 .08466 L
.07968 .06638 L
.0867 .05308 L
.09063 .04703 L
.09431 .04233 L
.09789 .03867 L
.10175 .03575 L
.10394 .03456 L
.10502 .0341 L
.10602 .03375 L
.107 .03347 L
.10789 .03327 L
.10888 .03312 L
.10942 .03306 L
.10994 .03303 L
.1109 .03301 L
.11144 .03303 L
.11195 .03306 L
.11298 .03318 L
.11355 .03328 L
.11408 .03339 L
.11604 .03394 L
.11789 .03469 L
.12003 .0358 L
.12201 .03706 L
.1265 .04066 L
.13408 .04876 L
.14119 .05797 L
.15742 .08049 L
.16516 .08981 L
.16938 .09403 L
.17331 .09726 L
.17668 .09944 L
.1784 .10034 L
.18027 .10113 L
.18134 .10149 L
.18232 .10177 L
.18325 .10198 L
.18426 .10216 L
.18517 .10228 L
.18602 .10234 L
.18692 .10236 L
.18788 .10233 L
.18843 .10229 L
Mistroke
.18894 .10224 L
.18989 .1021 L
.19092 .10189 L
.19202 .1016 L
.19402 .10091 L
.19586 .10007 L
.20009 .09746 L
.20456 .09373 L
.21211 .08543 L
.22039 .07418 L
.23707 .04919 L
.24497 .03857 L
.25227 .03062 L
.25593 .0275 L
.25982 .02494 L
.26184 .02393 L
.26373 .02319 L
.26474 .02287 L
.2658 .0226 L
.26636 .02249 L
.26696 .02238 L
.26748 .02231 L
.26803 .02225 L
.26904 .02219 L
.26999 .02218 L
.27092 .02222 L
.27177 .02231 L
.2727 .02245 L
.27371 .02266 L
.27477 .02294 L
.27576 .02326 L
.27923 .02481 L
.28117 .02597 L
.28295 .0272 L
.29074 .03439 L
.29796 .04322 L
.3143 .06721 L
.32196 .07832 L
.33023 .08871 L
.33403 .09265 L
.33803 .0961 L
.34145 .09841 L
.34325 .09937 L
.3452 .10022 L
.34624 .10059 L
.3472 .10087 L
.3481 .10109 L
.34909 .10128 L
.34998 .1014 L
.35081 .10147 L
Mistroke
.35169 .1015 L
.35263 .10148 L
.35365 .1014 L
.35422 .10133 L
.35476 .10125 L
.35574 .10106 L
.35678 .1008 L
.35877 .10012 L
.36058 .09931 L
.36412 .09722 L
.36795 .09422 L
.3749 .08708 L
.3903 .06585 L
.39846 .05355 L
.40721 .04128 L
.41153 .03597 L
.41563 .03159 L
.41961 .02804 L
.4233 .02544 L
.42679 .02365 L
.42855 .023 L
.42957 .02271 L
.43049 .02249 L
.43144 .02232 L
.43244 .02219 L
.43344 .02213 L
.434 .02211 L
.43453 .02212 L
.43549 .02217 L
.43636 .02226 L
.43737 .02242 L
.43832 .02263 L
.4402 .02319 L
.44197 .02389 L
.44598 .02613 L
.44989 .02912 L
.45409 .03313 L
.46863 .05191 L
.48419 .07513 L
.4924 .08602 L
.49691 .09105 L
.50115 .09499 L
.50525 .09798 L
.50756 .09928 L
.50968 .10021 L
.51148 .10081 L
.51249 .10106 L
.51344 .10125 L
.51444 .10139 L
.51536 .10146 L
Mistroke
.51586 .10149 L
.51641 .10149 L
.51741 .10146 L
.51834 .10138 L
.51921 .10125 L
.52017 .10107 L
.52121 .10081 L
.52331 .1001 L
.52524 .09923 L
.52895 .09698 L
.53247 .0942 L
.54002 .08634 L
.54806 .07576 L
.56254 .05416 L
.57064 .04268 L
.57489 .0373 L
.57939 .03232 L
.58334 .02867 L
.58543 .02703 L
.58767 .02552 L
.58972 .02437 L
.5916 .02352 L
.59251 .02318 L
.59349 .02287 L
.59436 .02263 L
.59528 .02243 L
.59623 .02228 L
.59711 .02218 L
.59806 .02212 L
.59909 .02212 L
.59999 .02217 L
.60095 .02227 L
.60185 .02242 L
.60267 .0226 L
.60469 .02319 L
.60688 .02408 L
.61084 .02638 L
.61502 .02967 L
.61945 .03405 L
.62738 .04379 L
.64297 .06672 L
.65721 .08639 L
.66097 .09059 L
.66506 .0945 L
.66897 .09748 L
.67252 .0995 L
.67465 .10039 L
.67562 .10071 L
.67665 .10099 L
.67775 .10122 L
Mistroke
.67877 .10137 L
.67933 .10143 L
.67986 .10146 L
.68043 .10149 L
.68105 .10149 L
.68207 .10145 L
.68265 .1014 L
.68318 .10133 L
.68416 .10117 L
.68519 .10094 L
.68699 .1004 L
.68897 .0996 L
.69285 .09739 L
.69693 .09423 L
.70423 .08668 L
.72066 .06378 L
.75 .02697 L
Mfstroke
gsave
.8 .49443 -61 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(supply) show
99.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->False,
  ImageSize->{332.75, 205.688},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005<0000cB000`400?l00000o`00003ooooooom=
ooooo`00OOooool3o`0004?ooooo0ol00002ooooo`Go0000Ooooool007cooooo00Go0000oooooooo
ooooooooo`000013ooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo0000Ooooool0
07cooooo00Go0000ooooooooooooooooo`000013ooooo`03o`000?oooooooooo00?ooooo00?o0000
ooooooooool0Ooooool007cooooo1?l00014ooooo`03o`000?oooooooooo00Cooooo00?o0000oooo
ooooool0O_ooool007cooooo00?o0000ooooooooool0AOooool01Ol0003ooooooooooooooooo0000
00?ooooo00?o0000ooooooooool0OOooool007gooooo00?o0000ooooooooool0@oooool2o`0000?o
oooo00Go0000ooooooooooooooooo`00001oooooo`00O_ooool2o`0004Cooooo00?o0000oooooooo
ool00_ooool3o`00083ooooo003oooooodgooooo003oooooodgooooo003ooooooc?ooooo0ol00002
ooooo`Go000000Koooooo`000?oooooo0000ooooool00002ooooo`?o00001Oooool00?oooooo=?oo
ool00ol0003oooooooooo`03ooooo`0;o`000?ooooooooooooooool0003oooooo`000?oooooo0000
ooooool000002?ooool003Oooooolol00009ooooo`03o`000?oooooooooo00?ooooo00[o0000oooo
ooooooooooooo`000?oooooo0000ooooool0003ooooo1Ol00004ooooo`00=oooool00ol0003ooooo
ooooo`15ooooo`03o`000?oooooooooo04Kooooo00?o0000ooooooooool0J?ooool00ol0003ooooo
ooooo`03ooooo`0;o`000?ooooooooooooooool0003oooooo`000?oooooo0000ooooool000000ooo
ool00ol0003oooooooooo`02ooooo`00=oooool00ol0003oooooooooo`15ooooo`03o`000?oooooo
oooo04Kooooo00?o0000ooooooooool0I_ooool01_l0003oooooo`000?oooooo0000ooooo`?o0000
0oooool2o`000003ooooool0003ooooo00;ooooo0ol00005ooooo`00=oooool00ol0003ooooooooo
o`3gooooo`05o`000?oooooo0000ooooool000005_ooool003Oooooo00?o0000ooooooooool0mooo
ool5o`0000?ooooo00?o0000ooooooooool04?ooool003Oooooo00?o0000ooooooooool0oooooolC
ooooo`00=oooool00ol0003oooooooooo`3ooooooa?ooooo000gooooo`03o`000?oooooooooo03co
oooo1Ol0000Rooooo`Ko00008_ooool6o`00087ooooo000gooooo`03o`000?oooooooooo03_ooooo
00?o0000ooooooooool00oooool00ol0003oooooooooo`0Nooooo`03o`000?oooooooooo00Cooooo
0_l0000Oooooo`;o00001Oooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo05cooooo
000gooooo`03o`000?oooooooooo03[ooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`0Looooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool07?ooool00ol0003ooooooooo
o`06ooooo`03o`000?oooooooooo01kooooo00?o0000ooooooooool0G?ooool003Oooooo00?o0000
ooooooooool05Oooool6o`0001kooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0J
ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool06oooool00ol0003oooooooooo`07
ooooo`03o`000?oooooooooo01cooooo00?o0000ooooooooool0GOooool003Oooooo00?o0000oooo
ooooool05?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo01_ooooo00?o0000oooo
ooooool02Oooool00ol0003oooooooooo`0Iooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool06_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo01_ooooo00?o0000oooo
ooooool0G_ooool003Oooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`05ooooo`03
o`000?oooooooooo01[ooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0Gooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`0:ooooo`03
o`000?oooooooooo01Wooooo00?o0000ooooooooool0Goooool003Oooooo00?o0000ooooooooool0
4oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool0
2oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0
5oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool0
H?ooool000Kooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`0Cooooo`03o`000?oo
oooooooo01?ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0Fooooo`03o`000?oo
oooooooo00gooooo00?o0000ooooooooool05Oooool00ol0003oooooooooo`0<ooooo`03o`000?oo
oooooooo01Kooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0Gooooo`03o`000?oo
oooooooo063ooooo0005ooooo`03o`000?oooooooooo01[ooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`0=ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`0Fooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool05?ooool0
0ol0003oooooooooo`0>ooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool03_ooool0
0ol0003oooooooooo`0Eooooo`03o`000?oooooooooo067ooooo0004ooooo`04o`000?oooooooooo
ooooo`;o000000Coooooo`000?l0003o00002?ooool2o`0000?ooooo0ol00005ooooo`03o`000?oo
oooooooo00;ooooo00Co0000oooooooooooooooo1?l00007ooooo`03o`000?oooooooooo01;ooooo
00?o0000ooooooooool02Oooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo00oooooo
00?o0000ooooooooool04oooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo01Cooooo
00?o0000ooooooooool03oooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo06;ooooo
0004ooooo`05o`000?ooooooooooooooool000000oooool00ol0003oooooooooo`06ooooo`04o`00
0?ooooooooooo`0000?ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`02ooooo`03
o`000?oooooooooo00;ooooo00Co0000oooooooooooo00001_ooool00ol0003oooooooooo`0Aoooo
o`03o`000?oooooooooo00_ooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`0@oooo
o`03o`000?oooooooooo017ooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0Boooo
o`03o`000?oooooooooo013ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`1Soooo
o`001?ooool01?l0003oooooooooooooool5o`0000;ooooo1?l000000ooooooo0000ooooo`06oooo
o`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`02oooo
o`04o`000?ooooooooooo`0000Kooooo]ol0001Nooooo`001?ooool00ol0003oooooooooo`02oooo
o`03o`000?oooooo000000Sooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo00?ooooo00Co0000oooooooooooooooo0ol00007ooooo`03o`000?oooooo
oooo013ooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooo
oooo01?ooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0Booooo`03o`000?oooooo
oooo013ooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooo
oooo06Cooooo0005ooooo`07o`000?ooooooooooooooool0003oooooo`000008ooooo`03o`000?oo
oooooooo00Gooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`04ooooo`05o`000?oo
ooooooooooooool000000_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo013ooooo
00?o0000ooooooooool03_ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo01?ooooo
00?o0000ooooooooool03oooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00oooooo
00?o0000ooooooooool04oooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo06Gooooo
0006ooooo`05o`000?ooooooooooooooool000002_ooool01?l0003oooooooooool00002ooooo`;o
00001?ooool00ol0003oooooooooo`06ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000oooo
ooooool01?ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00oooooo00?o0000oooo
ooooool03_ooool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo00gooooo00?o0000oooo
ooooool05Oooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo01Cooooo00?o0000oooo
ooooool03Oooool00ol0003oooooooooo`1Uooooo`002Oooool2o`0000_ooooo0ol00003ooooo`03
o`000?oooooooooo00gooooo1?l00007ooooo`03o`000?oooooooooo00oooooo00?o0000oooooooo
ool04?ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo01Kooooo00?o0000oooooooo
ool03?ooool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo00gooooo00?o0000oooooooo
ool05Oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo06Kooooo000gooooo`03o`00
0?oooooooooo00oooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0;ooooo`03o`00
0?oooooooooo01Oooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0Gooooo`03o`00
0?oooooooooo00cooooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo06Oooooo000gooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool04ooo
ool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo01Wooooo00?o0000ooooooooool02_oo
ool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool05ooo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo06Oooooo000gooooo`03o`000?oooooo
oooo00kooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo01[ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0Iooooo`03o`000?oooooo
oooo00Wooooo00?o0000ooooooooool06Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo06Sooooo000gooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool05Oooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo01cooooo00?o0000ooooooooool01_ooool00ol0
003oooooooooo`0Kooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool06oooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo06Sooooo000gooooo`03o`000?oooooooooo00go
oooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo01ko
oooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Mooooo`03o`000?oooooooooo00Co
oooo0_l0000Oooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0JOooool003Oooooo
00?o0000ooooooooool03Oooool00ol0003oooooooooo`0Gooooo`;o00000oooool2o`00027ooooo
0_l00003ooooo`;o00008Oooool2o`0000?ooooo00?o0000ooooooooool08?ooool2o`0000;ooooo
0ol0001/ooooo`00=oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo01Wooooo1Ol0
000Tooooo`?o00009Oooool3o`0002Cooooo1?l0001^ooooo`00=oooool00ol0003oooooooooo`0<
ooooo`03o`000?oooooooooo0?oooooo1?ooool003Oooooo00?o0000ooooooooool03?ooool00ol0
003oooooooooo`3oooooo`Cooooo000gooooo`03o`000?oooooooooo00cooooo00?o0000oooooooo
ool0ooooool4ooooo`00=oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo0?oooooo
1Oooool003Oooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`3oooooo`Gooooo000g
ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0ooooool5ooooo`00=oooool00ol0
003oooooooooo`0;ooooo`03o`000?oooooooooo0?oooooo1Oooool003Oooooo00?o0000oooooooo
ool02_ooool00ol0003oooooooooo`3oooooo`Kooooo000gooooo`03o`000?oooooooooo00[ooooo
00?o0000ooooooooool0ooooool6ooooo`00=oooool00ol0003oooooooooo`0:ooooo`03o`000?oo
oooooooo0?oooooo1_ooool003Oooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`3o
ooooo`Oooooo000gooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0ooooool7oooo
o`00=oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo0?oooooo1oooool003Oooooo
00?o0000ooooooooool02Oooool00ol0003oooooooooo`3oooooo`Oooooo000gooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool0ooooool8ooooo`00=oooool00ol0003oooooooooo`08
ooooo`03o`000?oooooooooo0?oooooo2?ooool003Oooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`3oooooo`Sooooo000gooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool0ooooool8ooooo`00=oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo0?oooooo
2Oooool003Oooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`3oooooo`Wooooo000g
ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0ooooool9ooooo`00=oooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo0?oooooo2Oooool003Oooooo00?o0000oooooooo
ool01oooool00ol0003oooooooooo`3oooooo`Wooooo000gooooo`03o`000?oooooooooo00Kooooo
00?o0000ooooooooool0ooooool:ooooo`00=oooool00ol0003oooooooooo`06ooooo`03o`000?oo
oooooooo0?oooooo2_ooool003Oooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`3o
ooooo`[ooooo000gooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0ooooool:oooo
o`00=oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo0?oooooo2_ooool003Oooooo
00?o0000ooooooooool01Oooool00ol0003oooooooooo`3oooooo`_ooooo000gooooo`03o`000?oo
oooooooo00Gooooo00?o0000ooooooooool0ooooool;ooooo`00=oooool00ol0003oooooooooo`05
ooooo`03o`000?oooooooooo0?oooooo2oooool003Oooooo00?o0000ooooooooool01Oooool00ol0
003oooooooooo`3oooooo`_ooooo000gooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool0ooooool;ooooo`00=oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo0?oooooo
3?ooool003Oooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`3oooooo`cooooo000g
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0ooooool<ooooo`00=oooool00ol0
003oooooooooo`04ooooo`03o`000?oooooooooo0?oooooo3?ooool003Oooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`3oooooo`cooooo000gooooo`03o`000?oooooooooo00Cooooo
00?o0000ooooooooool0ooooool<ooooo`00=oooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo0?oooooo3Oooool003Oooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`3o
ooooo`gooooo000gooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0ooooool=oooo
o`00=oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo0?oooooo3Oooool003Oooooo
00?o0000ooooooooool00oooool00ol0003oooooooooo`3oooooo`gooooo000gooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool0ooooool=ooooo`00=oooool00ol0003oooooooooo`02
ooooo`03o`000?oooooooooo0?oooooo3_ooool003Oooooo00?o0000ooooooooool00_ooool00ol0
003oooooooooo`3oooooo`kooooo000gooooo`03o`000?oooooooooo00;ooooo00?o0000oooooooo
ool0ooooool>ooooo`00=oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0?oooooo
3_ooool003Oooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`3oooooo`kooooo000g
ooooo`05o`000?ooooooooooooooool00000oooooolAooooo`00=oooool01Ol0003ooooooooooooo
oooo00000?oooooo4Oooool003Oooooo00Go0000ooooooooooooooooo`00003ooooooa7ooooo000g
ooooo`05o`000?ooooooooooooooool00000oooooolAooooo`00=oooool01Ol0003ooooooooooooo
oooo00000?oooooo4Oooool003Oooooo00Go0000ooooooooooooooooo`00003ooooooa7ooooo000g
ooooo`04o`000?ooooooooooo`000?oooooo4_ooool003Oooooo00Co0000oooooooooooo0000oooo
oolBooooo`00=oooool01?l0003oooooooooool0003ooooooa;ooooo000gooooo`04o`000?oooooo
ooooo`000?oooooo4_ooool003Oooooo00Co0000oooooooooooo0000oooooolBooooo`00=oooool0
1?l0003oooooooooool0003ooooooa;ooooo000gooooo`04o`000?ooooooooooo`000?oooooo4_oo
ool003Oooooo00?o0000ooooool00000oooooolCooooo`00=oooool00ol0003oooooo`00003ooooo
oa?ooooo000gooooo`03o`000?oooooo00000?oooooo4oooool003Oooooo00?o0000ooooool00000
oooooolCooooo`00=oooool00ol0003oooooo`00003ooooooa?ooooo000gooooo`03o`000?oooooo
00000?oooooo4oooool003Oooooo00?o0000ooooool00000oooooolCooooo`00=oooool00ol0003o
ooooo`00003ooooooa?ooooo000gooooo`;o0000oooooolDooooo`00=oooool2o`000?oooooo5?oo
ool003Oooooo0_l0003ooooooaCooooo000gooooo`;o00009Oooool2o`0002Kooooo0_l0000Voooo
o`;o00009Oooool3o`0007Cooooo000gooooo`;o00009?ooool4o`0002Cooooo00Co0000ooooool0
003o00009?ooool01?l0003oooooo`000?l0000Tooooo`04o`000?oooooo0000o`0007?ooooo000g
ooooo`?o00008_ooool2o`0000;ooooo00?o0000ooooooooool08_ooool01?l0003oooooooooool0
000Sooooo`05o`000?ooooooooooooooool000008oooool01Ol0003ooooooooooooooooo000007?o
oooo000gooooo`?o00008_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo023ooooo
00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Pooooo`03o`000?oooooooooo00;ooooo
00?o0000ooooooooool08?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo073ooooo
000gooooo`?o00008_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo023ooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo00?ooooo00?o
0000ooooooooool08?ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo073ooooo000g
ooooo`;o000000?oooooo`000?ooool07oooool00ol0003oooooooooo`04ooooo`03o`000?oooooo
oooo01oooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Oooooo`03o`000?oooooo
oooo00Cooooo00?o0000ooooooooool07_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooo
oooo06oooooo000gooooo`;o000000?oooooo`000?ooool07oooool00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo01kooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Moooo
o`03o`000?oooooooooo00Gooooo00?o0000ooooooooool07_ooool00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo06oooooo000gooooo`;o000000?oooooo`000?ooool07oooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo01gooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`0Mooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool07_ooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo06oooooo000gooooo`;o00000_ooool00ol0003ooooo
ooooo`0Looooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool07Oooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo01gooooo00?o0000ooooooooool01_ooool00ol0003ooooo
ooooo`0Looooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0K_ooool003Oooooo0_l0
0002ooooo`03o`000?oooooooooo01cooooo00?o0000ooooooooool01_ooool00ol0003ooooooooo
o`0Looooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool07?ooool00ol0003ooooooooo
o`06ooooo`03o`000?oooooooooo01cooooo00?o0000ooooooooool01_ooool00ol0003ooooooooo
o`1^ooooo`00=oooool01Ol0003ooooooooooooooooo000001kooooo00?o0000ooooooooool01ooo
ool00ol0003oooooooooo`0Kooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool06ooo
ool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo01cooooo00?o0000ooooooooool01_oo
ool00ol0003oooooooooo`1^ooooo`00=oooool00ol0003oooooooooo`02ooooo`03o`000?oooooo
oooo01_ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0Kooooo`03o`000?oooooo
oooo00Kooooo00?o0000ooooooooool06oooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo01_ooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`1^ooooo`00=oooool00ol0
003oooooooooo`02ooooo`03o`000?oooooooooo01[ooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`0Jooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool06_ooool00ol0
003oooooooooo`08ooooo`03o`000?oooooooooo01[ooooo00?o0000ooooooooool02?ooool00ol0
003oooooooooo`1]ooooo`00=oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo01[o
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0Jooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool06Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo01[o
oooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`1]ooooo`00=oooool00ol0003ooooo
ooooo`02ooooo`03o`000?oooooooooo01[ooooo00?o0000ooooooooool02Oooool00ol0003ooooo
ooooo`0Hooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool06Oooool00ol0003ooooo
ooooo`09ooooo`03o`000?oooooooooo01[ooooo00?o0000ooooooooool02?ooool00ol0003ooooo
ooooo`1]ooooo`00=oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo01Wooooo00?o
0000ooooooooool02Oooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo00Wooooo00?o
0000ooooooooool06Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo01[ooooo00?o
0000ooooooooool02?ooool00ol0003oooooooooo`1]ooooo`00=oooool00ol0003oooooooooo`03
ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0H
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`1/
ooooo`00=oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo01Sooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo00_ooooo00?o0000oooo
ooooool06?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo01Sooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`1/ooooo`00=oooool00ol0003oooooooooo`03ooooo`03
o`000?oooooooooo01Sooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0Fooooo`03
o`000?oooooooooo00_ooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0;ooooo`03
o`000?oooooooooo01Sooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`1/ooooo`00
=oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool0
2oooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0
5oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool0
2_ooool00ol0003oooooooooo`1/ooooo`00=oooool00ol0003oooooooooo`04ooooo`03o`000?oo
oooooooo01Oooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0Fooooo`03o`000?oo
oooooooo00_ooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`0;ooooo`03o`000?oo
oooooooo01Oooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`1[ooooo`00=oooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo01Kooooo00?o0000ooooooooool03?ooool0
0ol0003oooooooooo`0Fooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool05_ooool0
0ol0003oooooooooo`0<ooooo`03o`000?oooooooooo01Kooooo00?o0000ooooooooool03?ooool0
0ol0003oooooooooo`1[ooooo`00=oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
01Kooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo
00gooooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo
01Kooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`1[ooooo`00=oooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo01Kooooo00?o0000ooooooooool03Oooool00ol0003o
ooooooooo`0Dooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool05_ooool00ol0003o
ooooooooo`0<ooooo`03o`000?oooooooooo01Kooooo00?o0000ooooooooool03?ooool00ol0003o
ooooooooo`1[ooooo`00=oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo01Kooooo
00?o0000ooooooooool03Oooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo00gooooo
00?o0000ooooooooool05Oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo01Kooooo
00?o0000ooooooooool03?ooool00ol0003oooooooooo`1[ooooo`00=oooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool03_ooool00ol0003ooooooooo
o`0Dooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool05Oooool00ol0003ooooooooo
o`0=ooooo`03o`000?oooooooooo01Gooooo00?o0000ooooooooool03_ooool00ol0003ooooooooo
o`1Zooooo`00=oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo01Cooooo00?o0000
ooooooooool03_ooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo00kooooo00?o0000
ooooooooool05?ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo01Gooooo00?o0000
ooooooooool03_ooool00ol0003oooooooooo`1Zooooo`00=oooool00ol0003oooooooooo`05oooo
o`03o`000?oooooooooo01Cooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0Doooo
o`03o`000?oooooooooo00kooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`0>oooo
o`03o`000?oooooooooo01Cooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`1Zoooo
o`00=oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo01Cooooo00?o0000oooooooo
ool03oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00oooooo00?o0000oooooooo
ool05?ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo01Cooooo00?o0000oooooooo
ool03_ooool00ol0003oooooooooo`1Zooooo`00=oooool00ol0003oooooooooo`05ooooo`03o`00
0?oooooooooo01Cooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0Booooo`03o`00
0?oooooooooo00oooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`0>ooooo`03o`00
0?oooooooooo01?ooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`1Zooooo`00=ooo
ool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04?oo
ool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool04ooo
ool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool04?oo
ool00ol0003oooooooooo`1Yooooo`00=oooool00ol0003oooooooooo`06ooooo`03o`000?oooooo
oooo01;ooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0Booooo`03o`000?oooooo
oooo00oooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooo
oooo01?ooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0Tooooo`?o00000oooool3
o`0000Wooooo0ol0000`ooooo`00=oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo
01;ooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo
013ooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo
01;ooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0Uooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0_ooooo`00:?ooool2o`0000?o
oooo0ol00007ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool04_ooool00ol0003o
ooooooooo`0Aooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04?ooool00ol0003o
ooooooooo`0Booooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool04_ooool00ol0003o
ooooooooo`0@ooooo`03o`000?oooooooooo01Sooooo1?l00004ooooo`;o000000?oooooo`000?oo
ool00ol00003ooooo`?o00000_ooool5o`0000?ooooo00?o0000ooooooooool0;_ooool002Oooooo
00Co0000oooooooooooo00000oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Ko
oooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017o
oooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo013o
oooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo01co
oooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00002ooooo`04o`000?oooooo
ooooo`0000;ooooo00Go0000ooooooooooooooooo`000005ooooo`03o`000?oooooooooo02kooooo
000Vooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01_oooongo`0000kooooo0ol0
0003ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000_ooool01?l0003o
ooooooooool00003ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooool00000;oooool002Ko
oooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Oo
oooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo013o
oooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo017o
oooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo01Oo
oooo00?o0000ooooooooool01?ooool01?l0003oooooooooool00002ooooo`04o`000?oooooooooo
o`0000;ooooo00Co0000oooooooooooo00000oooool00ol0003oooooooooo`02ooooo`03o`000?oo
oooo000002oooooo000Vooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01_ooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool04_ooool0
0ol0003oooooooooo`0@ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool04Oooool0
0ol0003oooooooooo`0Booooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool04_ooool0
0ol0003oooooooooo`0Hooooo`Co000000Coooooo`000?l0003ooooo0_l000000ooooooo0000o`00
0002o`0000;ooooo1?l00004ooooo`04o`000?ooooooooooooooo`;o000000?oooooo`000?l00000
;_ooool002Oooooo00Co0000oooooooooooo00000_ooool2o`0000Sooooo00?o0000ooooooooool0
1oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0
4?ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool0
4_ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool0
<Oooool00ol0003oooooooooo`0dooooo`00:?ooool3o`0000?ooooo00?o0000ooooooooool01_oo
ool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool04_oo
ool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo01;ooooo00?o0000ooooooooool04?oo
ool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool04ooo
ool00ol0003oooooooooo`0_ooooo`?o0000=_ooool003Oooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`0>ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool04?ooool0
0ol0003oooooooooo`0Booooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool04_ooool0
0ol0003oooooooooo`0?ooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool0Ioooool0
03Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo
01Cooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo
00oooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo
01Cooooo00?o0000ooooooooool0Ioooool003Oooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`0>ooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool03_ooool00ol0003o
ooooooooo`0Cooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool05?ooool00ol0003o
ooooooooo`0>ooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool0Ioooool003Oooooo
00?o0000ooooooooool02?ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo01Cooooo
00?o0000ooooooooool03_ooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo00kooooo
00?o0000ooooooooool05?ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo01Cooooo
00?o0000ooooooooool0Ioooool003Oooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`0>ooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool03_ooool00ol0003ooooooooo
o`0Dooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool05?ooool00ol0003ooooooooo
o`0=ooooo`03o`000?oooooooooo01Gooooo00?o0000ooooooooool0Ioooool003Oooooo00?o0000
ooooooooool02?ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo01Gooooo00?o0000
ooooooooool03_ooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo00kooooo00?o0000
ooooooooool05?ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo01Kooooo00?o0000
ooooooooool0I_ooool003Oooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0<oooo
o`03o`000?oooooooooo01Gooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`0Doooo
o`03o`000?oooooooooo00kooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`0=oooo
o`03o`000?oooooooooo01Kooooo00?o0000ooooooooool0I_ooool003Oooooo00?o0000oooooooo
ool02Oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo01Gooooo00?o0000oooooooo
ool03Oooool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo00gooooo00?o0000oooooooo
ool05_ooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo01Kooooo00?o0000oooooooo
ool0I_ooool003Oooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0<ooooo`03o`00
0?oooooooooo01Kooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0Fooooo`03o`00
0?oooooooooo00cooooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`0;ooooo`03o`00
0?oooooooooo01Oooooo00?o0000ooooooooool0I_ooool003Oooooo00?o0000ooooooooool02Ooo
ool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo01Kooooo00?o0000ooooooooool03?oo
ool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool05_oo
ool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool0I_oo
ool003Oooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooo
oooo01Oooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`0Fooooo`03o`000?oooooo
oooo00cooooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooo
oooo01Sooooo00?o0000ooooooooool0IOooool003Oooooo00?o0000ooooooooool02_ooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool02oooool00ol0
003oooooooooo`0Gooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool05oooool00ol0
003oooooooooo`0:ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool0IOooool003Oo
oooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo01Oo
oooo00?o0000ooooooooool02oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo00_o
oooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo01So
oooo00?o0000ooooooooool0IOooool003Oooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`0:ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool02_ooool00ol0003ooooo
ooooo`0Hooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool06?ooool00ol0003ooooo
ooooo`09ooooo`03o`000?oooooooooo01Wooooo00?o0000ooooooooool0IOooool003Oooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo01Sooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo00[ooooo00?o
0000ooooooooool06?ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo01Wooooo00?o
0000ooooooooool0IOooool003Oooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0I
ooooo`03o`000?oooooooooo00[ooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`09
ooooo`03o`000?oooooooooo01[ooooo00?o0000ooooooooool0I?ooool003Oooooo00?o0000oooo
ooooool02oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo01Wooooo00?o0000oooo
ooooool02Oooool00ol0003oooooooooo`0Iooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool06Oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo01[ooooo00?o0000oooo
ooooool0I?ooool003Oooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`08ooooo`03
o`000?oooooooooo01[ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0Iooooo`03
o`000?oooooooooo00Wooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`07ooooo`03
o`000?oooooooooo01_ooooo00?o0000ooooooooool0I?ooool003Oooooo00?o0000ooooooooool0
2oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo01[ooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`0Jooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
6_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo01_ooooo00?o0000ooooooooool0
I?ooool003Oooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo01[ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0Kooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo01_ooooo00?o0000ooooooooool0I?ooool003Oooooo00?o0000ooooooooool03?ooool0
0ol0003oooooooooo`07ooooo`03o`000?oooooooooo01_ooooo00?o0000ooooooooool01_ooool0
0ol0003oooooooooo`0Kooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool07?ooool0
0ol0003oooooooooo`06ooooo`03o`000?oooooooooo01cooooo00?o0000ooooooooool0Hoooool0
03Oooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo
01cooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0Kooooo`03o`000?oooooooooo
00Oooooo00?o0000ooooooooool07?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
01gooooo00?o0000ooooooooool0Hoooool003Oooooo00?o0000ooooooooool03?ooool00ol0003o
ooooooooo`06ooooo`03o`000?oooooooooo01cooooo00?o0000ooooooooool01_ooool00ol0003o
ooooooooo`0Looooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool07?ooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo01gooooo00?o0000ooooooooool0Hoooool003Oooooo
00?o0000ooooooooool03Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo01gooooo
00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Mooooo`03o`000?oooooooooo00Gooooo
00?o0000ooooooooool07_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo01kooooo
00?o0000ooooooooool0H_ooool003Oooooo00?o0000ooooooooool03Oooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo01kooooo00?o0000ooooooooool01?ooool00ol0003ooooooooo
o`0Mooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool07_ooool00ol0003ooooooooo
o`03ooooo`03o`000?oooooooooo01oooooo00?o0000ooooooooool0H_ooool003Oooooo00?o0000
ooooooooool03Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo01kooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`0Nooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool07_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo01oooooo00?o0000
ooooooooool0H_ooool003Oooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`02oooo
o`03o`000?oooooooooo023ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Ooooo
o`03o`000?oooooooooo00?ooooo00?o0000ooooooooool08?ooool00ol0003oooooooooo`02oooo
o`03o`000?oooooooooo01oooooo00?o0000ooooooooool0H_ooool003Oooooo00?o0000oooooooo
ool03_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo023ooooo00?o0000oooooooo
ool00_ooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo00?ooooo00?o0000oooooooo
ool08?ooool01Ol0003ooooooooooooooooo000002?ooooo00?o0000ooooooooool00_ooool00ol0
003oooooooooo`1Looooo`00=oooool00ol0003oooooooooo`0>ooooo`;o00000oooool00ol0003o
ooooooooo`0Qooooo`04o`000?ooooooooooo`0002?ooooo00Go0000ooooooooooooooooo`00000S
ooooo`;o00000_ooool00ol0003oooooooooo`0Qooooo`05o`000?ooooooooooooooool00000Gooo
ool003Oooooo00?o0000ooooooooool03oooool4o`0002Cooooo1?l0000Tooooo`Co00009?ooool3
o`0002Gooooo0ol0001Pooooo`00oooooom=ooooo`00oooooom=ooooo`00oooooom=ooooo`00oooo
oom=ooooo`00oooooom=ooooo`00oooooom=ooooo`00oooooom=ooooo`00oooooom=ooooo`007ooo
ool3o`0000?ooooo0ol00009ooooo`?o00002Oooool3o`000?oooooo3Oooool0023ooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00?ooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`3oooooo`cooooo000Cooooo`Co00001?ooool2o`00
0003ooooool0003ooooo00?o00000oooool3o`0000;ooooo1Ol00003ooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooooooool00_ooool3o`0000;ooooo0ol00003ooooo`Go00000_ooool3o`00
00?ooooo0ol0003cooooo`005oooool01?l0003oooooooooool00002ooooo`04o`000?oooooooooo
o`0000;ooooo00Co0000oooooooooooo00000_ooool01Ol0003ooooooooooooooooo000000Gooooo
00?o0000ooooooooool00oooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000;o
oooo00?o0000ooooooooool01?ooool01Ol0003ooooooooooooooooo000000?ooooo00?o0000oooo
ool00000m_ooool001Cooooo0ol00003ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooo
oooooooo00000_ooool01?l0003oooooooooool00003ooooo`03o`000?oooooooooo00;ooooo00?o
0000ooooool000001?ooool00ol0003oooooooooo`02ooooo`04o`000?ooooooooooo`0000;ooooo
00?o0000ooooooooool01?ooool01Ol0003ooooooooooooooooo000000Gooooo1Ol0003booooo`00
4oooool00ol0003oooooooooo`04ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooo
oooo00000_ooool01?l0003oooooooooool00003ooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooool000001Oooool01Ol0003ooooooooooooooooo000000;ooooo00?o0000ooooooooool00_l0
0005ooooo`05o`000?ooooooooooooooool000000oooool00ol0003oooooo`000003ooooo`03o`00
0?oooooooooo0?3ooooo000Dooooo`Co000000Coooooo`000?l0003ooooo0_l000000ooooooo0000
o`000002o`0000;ooooo1?l00004ooooo`04o`000?ooooooooooooooo`;o000000?oooooo`000?l0
00001?ooool00ol0003oooooooooo`04o`0000;ooooo0_l000001?oooooo0000o`000?ooool3o`00
00Cooooo0ol00003ooooo`?o0000loooool002gooooo00?o0000ooooooooool02oooool00ol0003o
ooooooooo`3oooooo`oooooo000[ooooo`?o00007Oooool00ol0003oooooooooo`3nooooo`00oooo
oom=ooooo`00oooooom=ooooo`00\
\>"],
  ImageRangeCache->{{{0, 331.75}, {204.688, 0}} -> {-4.54236, -0.722001, \
0.0824443, 0.0577437}}]
}, Closed]]
}, Closed]],

Cell[TextData[{
  "\nAnother supply and demand model is \n\n   ",
  StyleBox["  dS/dt = k ( D - S )\n     \n",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "which says that the rate of change of supply is proportional\n to the \
difference between demand and supply."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[TextData["Periodic Demand - General"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Solve the supply and demand differential equation described above."], "Text",\

  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[{\(demand = c1 - c2\ Cos[\[Alpha]\ t]\), "\n", 
    RowBox[{"supplyRule", "=", 
      RowBox[{"DSolve", "[", 
        RowBox[{
          RowBox[{
            RowBox[{
              SuperscriptBox["S", "\[Prime]",
                MultilineFunction->None], "[", "t", "]"}], 
            "==", \(k1\ \((demand - S[t])\)\)}], ",", \(S[t]\), ",", "t"}], 
        "]"}]}]}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(c1 - c2\ Cos[t\ \[Alpha]]\)], "Output"],

Cell[BoxData[
    \({{S[
            t] \[Rule] \[ExponentialE]\^\(\(-k1\)\ t\)\ C[
                1] + \[ExponentialE]\^\(\(-k1\)\ t\)\ \((\(c1\ \
\[ExponentialE]\^\(k1\ t\)\ \((c1\ k1 - c2\ k1\ Cos[t\ \[Alpha]])\)\)\/\(k1\ \
\((c1 - c2\ Cos[t\ \[Alpha]])\)\) - \(c2\ \[ExponentialE]\^\(k1\ t\)\ k1\ \
Cos[t\ \[Alpha]]\ \((c1\ k1 - c2\ k1\ Cos[t\ \[Alpha]])\)\)\/\(\((k1 - \
\[ImaginaryI]\ \[Alpha])\)\ \((k1 + \[ImaginaryI]\ \[Alpha])\)\ \((c1 - c2\ \
Cos[t\ \[Alpha]])\)\) - \(c2\ \[ExponentialE]\^\(k1\ t\)\ \[Alpha]\ \((c1\ k1 \
- c2\ k1\ Cos[t\ \[Alpha]])\)\ Sin[t\ \[Alpha]]\)\/\(\((k1 - \[ImaginaryI]\ \
\[Alpha])\)\ \((k1 + \[ImaginaryI]\ \[Alpha])\)\ \((c1 - c2\ Cos[t\ \
\[Alpha]])\)\))\)}}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(supply[t] /. 
      a1_\ Cos[\[Alpha]\ t] + 
          a2_\ Sin[\[Alpha]\ t] \[RuleDelayed] \@\(a1\^2 + a2\^2\)\ Sin[\
\[Alpha]\ t + ArcTan[a1\/a2]]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\[ExponentialE]\^\(\(-k1\)\ t\)\ C[
          1] + \[ExponentialE]\^\(\(-k1\)\ t\)\ \((\(c1\ \
\[ExponentialE]\^\(k1\ t\)\ \((c1\ k1 - c2\ k1\ Cos[t\ \[Alpha]])\)\)\/\(k1\ \
\((c1 - c2\ Cos[t\ \[Alpha]])\)\) + \[Sqrt]\((\(c2\^2\ \[ExponentialE]\^\(2\ \
k1\ t\)\ k1\^2\ \((c1\ k1 - c2\ k1\ Cos[t\ \[Alpha]])\)\^2\)\/\(\((k1 - \
\[ImaginaryI]\ \[Alpha])\)\^2\ \((k1 + \[ImaginaryI]\ \[Alpha])\)\^2\ \((c1 - \
c2\ Cos[t\ \[Alpha]])\)\^2\) + \(c2\^2\ \[ExponentialE]\^\(2\ k1\ t\)\ \
\[Alpha]\^2\ \((c1\ k1 - c2\ k1\ Cos[t\ \[Alpha]])\)\^2\)\/\(\((k1 - \
\[ImaginaryI]\ \[Alpha])\)\^2\ \((k1 + \[ImaginaryI]\ \[Alpha])\)\^2\ \((c1 - \
c2\ Cos[t\ \[Alpha]])\)\^2\))\)\ Sin[
                t\ \[Alpha] + ArcTan[k1\/\[Alpha]]])\)\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Periodic Demand - Example"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Let D = 8 - 2 Cos[2Pi/12] and k = 3/4. Find supply in terms of t."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[{\(demand = 
      c1 - c2\ Cos[\[Alpha]\ t] /. {c1 \[Rule] 8, 
          c2 \[Rule] 2, \[Alpha] \[Rule] \(2\ \[Pi]\)\/12}\), "\n", 
    RowBox[{"supplyRule", "=", 
      RowBox[{
        RowBox[{"DSolve", "[", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{
                RowBox[{
                  RowBox[{
                    SuperscriptBox["S", "\[Prime]",
                      MultilineFunction->None], "[", "t", "]"}], 
                  "==", \(k1\ \((demand - S[t])\)\)}], ",", \(S[0] == 5\)}], 
              "}"}], ",", \(S[t]\), ",", "t"}], "]"}], 
        "/.", \(k1 \[Rule] 3\/4\)}]}]}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(8 - 2\ Cos[\(\[Pi]\ t\)\/6]\)], "Output"],

Cell[BoxData[
    \({{S[
            t] \[Rule] \((\[ExponentialE]\^\(\(\(-3\)\ t\)/4\)\ \((\(-\(81\/4\
\)\) + 162\ \[ExponentialE]\^\(\(3\ t\)/4\) - 3\ \[Pi]\^2 + 
                    8\ \[ExponentialE]\^\(\(3\ t\)/4\)\ \[Pi]\^2 - 
                    81\/2\ \[ExponentialE]\^\(\(3\ t\)/4\)\ Cos[\(\[Pi]\ \
t\)\/6] - 
                    9\ \[ExponentialE]\^\(\(3\ t\)/4\)\ \[Pi]\ Sin[\(\[Pi]\ t\
\)\/6])\))\)/\((\((\(-\(\(9\ \[ImaginaryI]\)\/2\)\) + \[Pi])\)\ \((\(9\ \
\[ImaginaryI]\)\/2 + \[Pi])\))\)}}\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Clear[supply]\), "\n", 
    \(supply[t_] = 
      S[t] /. supplyRule\[LeftDoubleBracket]1\[RightDoubleBracket]\)}], \
"Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\((\[ExponentialE]\^\(\(\(-3\)\ t\)/4\)\ \((\(-\(81\/4\)\) + 
              162\ \[ExponentialE]\^\(\(3\ t\)/4\) - 3\ \[Pi]\^2 + 
              8\ \[ExponentialE]\^\(\(3\ t\)/4\)\ \[Pi]\^2 - 
              81\/2\ \[ExponentialE]\^\(\(3\ t\)/4\)\ Cos[\(\[Pi]\ t\)\/6] - 
              9\ \[ExponentialE]\^\(\(3\ t\)/4\)\ \[Pi]\ Sin[\(\[Pi]\ \
t\)\/6])\))\)/\((\((\(-\(\(9\ \[ImaginaryI]\)\/2\)\) + \[Pi])\)\ \((\(9\ \
\[ImaginaryI]\)\/2 + \[Pi])\))\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(supply[t] /. 
      a1_\ Cos[\[Alpha]_\ t] + 
          a2_\ Sin[\[Alpha]_\ t] \[RuleDelayed] \@\(a1\^2 + a2\^2\)\ Sin[\
\[Alpha]\ t + ArcTan[a1\/a2]]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(\((\[ExponentialE]\^\(\(\(-3\)\ t\)/4\)\ \((\(-\(81\/4\)\) + 
              162\ \[ExponentialE]\^\(\(3\ t\)/4\) - 3\ \[Pi]\^2 + 
              8\ \[ExponentialE]\^\(\(3\ t\)/4\)\ \[Pi]\^2 + \@\(6561\/4\ \
\[ExponentialE]\^\(\(3\ t\)/2\) + 81\ \[ExponentialE]\^\(\(3\ t\)/2\)\ \
\[Pi]\^2\)\ Sin[\(\[Pi]\ t\)\/6 + 
                    ArcTan[9\/\(2\ \[Pi]\)]])\))\)/\((\((\(-\(\(9\ \
\[ImaginaryI]\)\/2\)\) + \[Pi])\)\ \((\(9\ \[ImaginaryI]\)\/2 + \
\[Pi])\))\)\)], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(p = 
      Plot[{8, demand, supply[t]}, {t, 0, 30}, 
        Ticks \[Rule] {{6, 12, 18, 24, 30}, {{8, "\<C1\>"}}}, 
        AxesOrigin \[Rule] {0, 5}, 
        AxesLabel \[Rule] {"\<Time (months)\>", "\<supply/demand\>"}, 
        PlotRange \[Rule] {{0, 40}, {5, 10.3}}, 
        PlotStyle \[Rule] {{Thickness[ .004]}, {Thickness[ .007]}}]\)], \
"Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 0.025 -0.583051 0.11661 [
[.15 -0.0125 -3 -9 ]
[.15 -0.0125 3 0 ]
[.3 -0.0125 -6 -9 ]
[.3 -0.0125 6 0 ]
[.45 -0.0125 -6 -9 ]
[.45 -0.0125 6 0 ]
[.6 -0.0125 -6 -9 ]
[.6 -0.0125 6 0 ]
[.75 -0.0125 -6 -9 ]
[.75 -0.0125 6 0 ]
[1.025 0 0 -6 ]
[1.025 0 82 6 ]
[-0.0125 .34983 -16 -6 ]
[-0.0125 .34983 0 6 ]
[0 .64303 -41 0 ]
[0 .64303 41 12 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.15 0 m
.15 .00625 L
s
[(6)] .15 -0.0125 0 1 Mshowa
.3 0 m
.3 .00625 L
s
[(12)] .3 -0.0125 0 1 Mshowa
.45 0 m
.45 .00625 L
s
[(18)] .45 -0.0125 0 1 Mshowa
.6 0 m
.6 .00625 L
s
[(24)] .6 -0.0125 0 1 Mshowa
.75 0 m
.75 .00625 L
s
[(30)] .75 -0.0125 0 1 Mshowa
0 0 m
1 0 L
s
gsave
1.025 0 -61 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Time) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
93.000 13.000 moveto
(H) show
99.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(months) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
135.000 13.000 moveto
(L) show
141.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .34983 m
.00625 .34983 L
s
gsave
-0.0125 .34983 -77 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(C1) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
0 .61803 L
s
gsave
0 .64303 -102 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(supply) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
99.000 13.000 moveto
(\\220) show
105.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(demand) show
141.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.004 w
0 .34983 m
.03043 .34983 L
.06361 .34983 L
.09477 .34983 L
.12474 .34983 L
.15664 .34983 L
.18735 .34983 L
.21998 .34983 L
.25143 .34983 L
.28168 .34983 L
.31386 .34983 L
.34485 .34983 L
.37465 .34983 L
.40637 .34983 L
.43691 .34983 L
.46937 .34983 L
.50064 .34983 L
.53072 .34983 L
.56273 .34983 L
.59354 .34983 L
.62629 .34983 L
.65784 .34983 L
.6882 .34983 L
.72049 .34983 L
.75 .34983 L
s
.007 w
0 .11661 m
.00093 .11665 L
.00177 .11677 L
.00274 .11699 L
.00366 .11729 L
.00529 .11804 L
.00707 .11916 L
.00902 .12076 L
.01109 .12288 L
.01481 .12774 L
.02224 .14146 L
.03043 .16238 L
.04756 .22304 L
.06361 .29471 L
.09414 .44083 L
.10966 .50465 L
.11786 .53218 L
.1266 .55561 L
.13098 .5648 L
.13511 .5718 L
.13881 .57668 L
.14072 .57866 L
.14282 .58042 L
.14377 .58107 L
.14479 .58166 L
.14567 .58209 L
.14663 .58247 L
.14719 .58265 L
.14771 .58278 L
.14874 .58297 L
.14967 .58305 L
.15066 .58303 L
.15151 .58293 L
.15243 .58275 L
.1533 .5825 L
.15409 .5822 L
.15593 .58125 L
.15787 .57989 L
.16181 .57595 L
.16539 .57104 L
.17342 .55555 L
.18086 .53601 L
.18788 .51341 L
.21818 .38305 L
.23352 .30843 L
.2504 .23153 L
.25813 .20069 L
.26643 .17191 L
.27421 .1498 L
.28143 .13403 L
Mistroke
.28529 .12758 L
.28941 .12233 L
.29176 .12007 L
.29397 .11847 L
.29494 .11792 L
.29596 .11744 L
.29649 .11724 L
.29708 .11705 L
.29811 .11679 L
.29862 .11671 L
.29917 .11665 L
.30018 .11661 L
.30116 .11668 L
.30206 .11683 L
.30304 .11708 L
.30412 .11748 L
.30524 .11801 L
.3063 .11864 L
.30998 .12168 L
.31204 .12399 L
.31394 .12647 L
.32168 .14023 L
.32887 .15795 L
.34518 .21346 L
.37597 .35457 L
.39168 .42966 L
.40869 .50107 L
.41667 .52849 L
.4251 .55206 L
.43231 .56722 L
.4364 .57365 L
.44022 .57817 L
.44226 .57999 L
.44415 .5813 L
.44522 .58188 L
.44623 .58232 L
.44728 .58267 L
.44783 .58281 L
.44843 .58293 L
.44938 .58303 L
.45041 .58304 L
.45093 .58301 L
.45149 .58294 L
.4525 .58273 L
.4535 .58242 L
.45445 .58204 L
.45623 .58107 L
.45799 .57979 L
.45987 .57809 L
.46323 .57415 L
Mistroke
.46685 .56868 L
.47083 .5612 L
.47882 .54183 L
.48613 .51941 L
.50257 .45539 L
.53386 .3068 L
.54965 .23472 L
.56395 .17998 L
.5714 .1572 L
.57946 .13786 L
.58389 .12976 L
.58797 .12398 L
.59186 .11999 L
.59382 .11856 L
.59494 .11792 L
.59598 .11744 L
.59694 .11709 L
.59796 .11682 L
.59898 .11666 L
.59956 .11662 L
.60011 .11661 L
.60109 .11667 L
.60199 .11681 L
.60298 .11706 L
.60402 .11744 L
.60584 .11835 L
.60752 .1195 L
.61135 .12317 L
.61553 .12884 L
.61932 .13544 L
.62783 .15511 L
.64295 .20476 L
.65933 .27465 L
.69157 .42914 L
.70761 .49702 L
.71545 .52462 L
.72261 .54573 L
.72939 .56166 L
.73582 .57284 L
.73934 .57726 L
.74261 .58026 L
.74449 .5815 L
.74619 .58231 L
.74713 .58263 L
.74815 .58288 L
.74912 .58301 L
.75 .58305 L
Mfstroke
.004 w
0 0 m
.03043 .08119 L
.06361 .17777 L
.09477 .30145 L
.12474 .42537 L
.14144 .48183 L
.14934 .50292 L
.15664 .51853 L
.16421 .53043 L
.1682 .53485 L
.17021 .53658 L
.17242 .5381 L
.17342 .53865 L
.17436 .53909 L
.17522 .53942 L
.17614 .53971 L
.17713 .53995 L
.17805 .54009 L
.17861 .54014 L
.17914 .54017 L
.18013 .54015 L
.18101 .54006 L
.18193 .5399 L
.18273 .53971 L
.1836 .53943 L
.18554 .53859 L
.18735 .53752 L
.19129 .53424 L
.19558 .52924 L
.20337 .51644 L
.21096 .49969 L
.21799 .48079 L
.24891 .37047 L
.27864 .25578 L
.29387 .2083 L
.30244 .18762 L
.30624 .18008 L
.3103 .17322 L
.31434 .16765 L
.31802 .16372 L
.31979 .16221 L
.32171 .16087 L
.32353 .15989 L
.3252 .15923 L
.32614 .15896 L
.32715 .15875 L
.3281 .15863 L
.32897 .15859 L
.32999 .15862 L
.33056 .15868 L
Mistroke
.3311 .15876 L
.33208 .15896 L
.33312 .15927 L
.33421 .15969 L
.33539 .16025 L
.33752 .16156 L
.3415 .16501 L
.34539 .16961 L
.34901 .17498 L
.35723 .19085 L
.36525 .21084 L
.37383 .23656 L
.40645 .35922 L
.42278 .42274 L
.43787 .47407 L
.45253 .51221 L
.45993 .52586 L
.46414 .53175 L
.46809 .536 L
.46989 .53751 L
.4718 .53883 L
.4729 .53945 L
.4739 .53993 L
.47485 .5403 L
.47585 .54062 L
.47635 .54074 L
.4769 .54086 L
.47787 .541 L
.47842 .54104 L
.479 .54106 L
.47955 .54105 L
.48006 .54102 L
.48103 .5409 L
.48158 .5408 L
.48209 .54069 L
.48302 .54041 L
.48402 .54005 L
.48573 .53922 L
.48759 .53805 L
.49094 .53521 L
.49494 .53064 L
.4986 .52533 L
.50631 .51085 L
.51348 .49359 L
.52978 .44309 L
.5605 .32428 L
.57616 .26458 L
.58441 .23642 L
.59315 .21028 L
.60094 .1909 L
Mistroke
.60507 .18231 L
.60952 .17446 L
.61359 .1686 L
.61731 .1644 L
.6191 .16278 L
.62106 .16131 L
.6229 .16021 L
.62461 .15944 L
.62563 .15911 L
.62618 .15896 L
.6267 .15884 L
.62761 .15869 L
.62862 .15861 L
.62918 .1586 L
.62971 .15862 L
.63071 .15871 L
.63126 .1588 L
.63178 .1589 L
.63294 .15922 L
.63388 .15956 L
.63475 .15994 L
.63675 .16105 L
.63869 .16245 L
.64079 .1643 L
.64451 .16848 L
.64844 .17407 L
.65544 .18698 L
.671 .22764 L
.68547 .2771 L
.71623 .39791 L
.74893 .50414 L
.75 .50663 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->True,
  ImageSize->{359.812, 222.375},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005W0000gR000`400?l00000o`00003ooooooomX
ooooo`00oooooomXooooo`00oooooomXooooo`00oooooomXooooo`00oooooomXooooo`00oooooomX
ooooo`00oooooomXooooo`00oooooomXooooo`00oooooomXooooo`00oooooomXooooo`00oooooomX
ooooo`00oooooomXooooo`00oooooomXooooo`00oooooomXooooo`00oooooomXooooo`00oooooomX
ooooo`00oooooomXooooo`00oooooomXooooo`00oooooomXooooo`00oooooomXooooo`00oooooomX
ooooo`00oooooomXooooo`00oooooomXooooo`00oooooomXooooo`00oooooomXooooo`00oooooomX
ooooo`00BOooool3o`0001gooooo0ol00002ooooo`Go00006?ooool3o`0000?ooooo0ol0000Ioooo
o`Go00000oooool3o`0001Sooooo0ol00004ooooo`;o0000S_ooool004Sooooo00Go0000oooooooo
ooooooooo`00000Mooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00006Oooool0
1Ol0003ooooooooooooooooo000000?ooooo00?o0000ooooooooool05oooool01?l0003ooooooooo
ool00004ooooo`03o`000?oooooooooo01Kooooo00Go0000ooooooooooooooooo`000002ooooo`04
o`000?ooooooooooo`0008gooooo0018ooooo`05o`000?ooooooooooooooool000007Oooool00ol0
003oooooooooo`03ooooo`03o`000?oooooooooo01Wooooo00Go0000ooooooooooooooooo`000003
ooooo`03o`000?oooooooooo01Sooooo00Co0000oooooooooooooooo1Ol0000Kooooo`04o`000?oo
ooooooooo`0000;ooooo00?o0000ooooooooool0Roooool004Sooooo1?l0000Nooooo`03o`000?oo
oooooooo00Cooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`02ooooo`?o00007?oo
ool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo01Sooooo0_l00003ooooo`04o`00
0?ooooooooooo`0008gooooo0018ooooo`03o`000?oooooooooo01oooooo00Go0000oooooooooooo
ooooo`000003ooooo`03o`000?oooooooooo01Oooooo00Go0000ooooooooooooooooo`000003oooo
o`03o`000?oooooooooo01Kooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooo
000001cooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`2;ooooo`00BOooool0
0ol0003oooooooooo`0Mooooo`;o00000oooool01Ol0003ooooooooooooooooo000001Sooooo0_l0
0003ooooo`05o`000?ooooooooooooooool000006?ooool01Ol0003ooooooooooooooooo000000?o
oooo0_l0000Hooooo`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool0002=
ooooo`00B_ooool2o`0001kooooo00?o0000ooooooooool00_ooool3o`0001[ooooo00?o0000oooo
ooooool00_ooool3o`0001[ooooo0ol00005ooooo`03o`000?oooooooooo01Oooooo0ol00004oooo
o`;o0000S_ooool00?oooooo>Oooool00ol0003oooooooooo`0Tooooo`03o`000?oooooooooo00Go
oooo003oooooocSooooo00?o0000ooooooooool09_ooool00ol0003oooooooooo`04ooooo`00oooo
oolHooooo`?o00000_ooool5o`000006ooooool0003oooooo`000?oooooo00000_ooool3o`0000[o
oooo00Wo0000ooooooooooooooooo`000?oooooo0000ooooool000000_ooool3o`0000;ooooo0ol0
00000ooooooo0000o`000002ooooo`;o00000_ooool:o`0000Gooooo00?o0000ooooooooool00ooo
ool00?oooooo6Oooool00ol0003oooooooooo`03ooooo`0;o`000?ooooooooooooooool0003ooooo
o`000?oooooo0000ooooool000003Oooool02ol0003ooooooooooooooooo0000ooooool0003ooooo
o`000?oooooo000000?ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00002
ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool00oooool00ol0003ooooooooo
o`02ooooo`03o`000?oooooooooo00?ooooo000YooooonOo00002?ooool00ol0003oooooooooo`03
ooooo`0:o`000?ooooooooooooooool0003oooooo`000?oooooo0000ooooo`Go00002Oooool02ol0
003ooooooooooooooooo0000ooooool0003oooooo`000?oooooo000000?ooooo00Co0000oooooooo
oooo00000_ooool01?l0003oooooooooool00005ooooo`04o`000?ooooooooooo`0000;ooooo0ol0
0005ooooo`03o`000?oooooooooo00?ooooo000Yooooo`03o`000?oooooooooo01oooooo00?o0000
ooooooooool08?ooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo023ooooo00?o0000
ooooooooool07oooool00ol0003oooooooooo`10ooooo`03o`000?oooooooooo00?ooooo00_o0000
ooooooooooooooooo`000?oooooo0000ooooool0003oooooo`000003ooooo`03o`000?oooooooooo
00Oooooo00_o0000ooooooooooooooooo`000?oooooo0000ooooool0003oooooo`000003ooooo`04
o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00001Oooool01_l0003oooooooooool0
003oooooo`0000Sooooo00?o0000ooooooooool00oooool002Wooooo0_l0003[ooooo`06o`000?oo
oooo0000ooooool0003ooooo0ol00003ooooo`;o000000?oooooo`000?ooool00_ooool3o`0000_o
oooo00?o0000ooooooooool00_l000000ooooooo0000ooooo`02ooooo`?o00000_ooool4o`0000;o
oooo1?l00003ooooo`?o00000oooool4o`0000?ooooo00?o0000ooooooooool01?ooool002Wooooo
0_l0003[ooooo`05o`000?oooooo0000ooooool000007Oooool00ol0003oooooooooo`0Booooo`03
o`000?oooooooooo00?ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`05ooooo`00
:Oooool2o`000>_ooooo1Ol00003ooooo`03o`000?oooooooooo02cooooo00?o0000ooooooooool0
0_ooool2o`0001?ooooo000Yooooo`03o`000?oooooo00000?oooooo??ooool002Wooooo00?o0000
ooooool00000oooooollooooo`00:Oooool01?l0003oooooooooool0003ooooooc_ooooo000Yoooo
o`04o`000?ooooooooooo`000?oooooo>oooool002Wooooo00Co0000oooooooooooo0000oooooolk
ooooo`00:Oooool01Ol0003ooooooooooooooooo00000?oooooo>_ooool002Wooooo00Go0000oooo
ooooooooooooo`00003ooooooc[ooooo000Yooooo`05o`000?ooooooooooooooool00000oooooolj
ooooo`00:Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0?oooooo=oooool002Wo
oooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`3oooooocOooooo000Yooooo`03o`00
0?oooooooooo00?ooooo00?o0000ooooooooool0oooooolfooooo`00:Oooool00ol0003ooooooooo
o`03ooooo`03o`000?oooooooooo0?oooooo=_ooool002Wooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`3oooooocKooooo000Yooooo`03o`000?oooooooooo00Cooooo00?o0000oooo
ooooool0ooooooleooooo`00:Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo0?oo
oooo=Oooool002Wooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`3oooooocGooooo
000Yooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0ooooooldooooo`00:Oooool0
0ol0003oooooooooo`05ooooo`03o`000?oooooooooo0?oooooo=?ooool002Wooooo00?o0000oooo
ooooool01Oooool00ol0003oooooooooo`3oooooocCooooo000Yooooo`03o`000?oooooooooo00Ko
oooo00?o0000ooooooooool0oooooolcooooo`00:Oooool00ol0003oooooooooo`06ooooo`03o`00
0?oooooooooo0?oooooo<oooool002Wooooo00?o0000ooooooooool01_ooool00ol0003ooooooooo
o`3ooooooc?ooooo000Yooooo`;o00002?ooool00ol0003oooooooooo`0fooooo`Co0000@Oooool4
o`000;;ooooo000Yooooo`03o`000?oooooo000000Oooooo00?o0000ooooooooool0=Oooool00ol0
003oooooooooo`02ooooo`03o`000?oooooooooo03gooooo00?o0000ooooooooool00_ooool00ol0
003oooooooooo`2_ooooo`00:Oooool01?l0003oooooooooool00006ooooo`03o`000?oooooooooo
03Cooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0looooo`03o`000?oooooooooo
00?ooooo00?o0000ooooooooool0[_ooool002Wooooo00Co0000oooooooooooo00001oooool00ol0
003oooooooooo`0cooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0>oooool00ol0
003oooooooooo`04ooooo`03o`000?oooooooooo0:kooooo000Yooooo`05o`000?oooooooooooooo
ool000001_ooool00ol0003oooooooooo`0booooo`03o`000?oooooooooo00Kooooo00?o0000oooo
ooooool0>Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo0:gooooo000Yooooo`03
o`000?oooooooooo00;ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0booooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool0>?ooool00ol0003oooooooooo`06ooooo`03
o`000?oooooooooo0:gooooo000Yooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`0aooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
=oooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo0:cooooo000Yooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0`ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool0=oooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo0:cooooo000Yooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`0`ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0=_ooool0
0ol0003oooooooooo`09ooooo`03o`000?oooooooooo0:_ooooo000Yooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0_ooooo`03o`000?oooooooooo
00Wooooo0ol0000fooooo`03o`000?oooooooooo00Wooooo0ol0002/ooooo`00:Oooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0;_ooool00ol0003o
ooooooooo`08ooooo`Go0000=Oooool00ol0003oooooooooo`08ooooo`?o000000?oooooo`000?oo
ool0Z_ooool002Wooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`03ooooo`03o`00
0?oooooooooo02kooooo00?o0000ooooooooool01oooool01?l0003oooooooooool00002ooooo`03
o`000?oooooooooo037ooooo00?o0000ooooooooool02Oooool01_l0003oooooooooool0003ooooo
o`000:[ooooo000Yooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool00oooool00ol0
003oooooooooo`0]ooooo`03o`000?oooooooooo00Sooooo00Go0000ooooooooooooooooo`000002
ooooo`03o`000?oooooooooo033ooooo00?o0000ooooooooool02?ooool01Ol0003ooooooooooooo
oooo000000;ooooo00?o0000ooooooooool0Yoooool002Wooooo00?o0000ooooooooool01Oooool0
0ol0003oooooooooo`03ooooo`03o`000?oooooooooo02cooooo00?o0000ooooooooool01oooool0
0ol0003oooooooooo`02ooooo`05o`000?ooooooooooooooool00000<Oooool00ol0003ooooooooo
o`07ooooo`03o`000?oooooooooo00;ooooo00Go0000ooooooooooooooooo`00002Xooooo`00:Ooo
ool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0;?oo
ool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00?ooooo00Go0000oooooooooooooooo
o`00000`ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool00_ooool01Ol0003ooooo
oooooooooooo00000:Sooooo000Yooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`0[ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0
1?ooool01Ol0003ooooooooooooooooo000002oooooo00?o0000ooooooooool01oooool00ol0003o
ooooooooo`04ooooo`05o`000?ooooooooooooooool00000Yoooool002Wooooo00?o0000oooooooo
ool01Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo02_ooooo00?o0000oooooooo
ool01_ooool00ol0003oooooooooo`05ooooo`05o`000?ooooooooooooooool00000;oooool00ol0
003oooooooooo`07ooooo`03o`000?oooooooooo00Cooooo00Go0000ooooooooooooooooo`00002W
ooooo`00:Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000oooo
ooooool0:_ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`0[ooooo`03o`000?oooooooooo00Oooooo00?o0000oooo
ooooool01Oooool01Ol0003ooooooooooooooooo00000:Oooooo000Yooooo`03o`000?oooooooooo
00Kooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Yooooo`03o`000?oooooooooo
00Kooooo00?o0000ooooooooool01oooool01Ol0003ooooooooooooooooo000002gooooo00?o0000
ooooooooool01oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool0Y?ooool002Wooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`03oooo
o`03o`000?oooooooooo02Wooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`07oooo
o`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0:_ooool00ol0003oooooooooo`06oooo
o`03o`000?oooooooooo00Oooooo00Go0000ooooooooooooooooo`00002Vooooo`00:Oooool00ol0
003oooooooooo`06ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0:Oooool00ol0
003oooooooooo`06ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool00_ooool00ol0
003oooooooooo`0Zooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool01oooool00ol0
003oooooooooo`02ooooo`03o`000?oooooooooo0:?ooooo000Yooooo`03o`000?oooooooooo00Ko
oooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Xooooo`03o`000?oooooooooo00Go
oooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo02So
oooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00;o
oooo00?o0000ooooooooool0Xoooool002Wooooo00?o0000ooooooooool01_ooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo02Oooooo00?o0000ooooooooool01_ooool00ol0003ooooo
ooooo`09ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0:?ooool00ol0003ooooo
ooooo`06ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool00_ooool00ol0003ooooo
ooooo`2Sooooo`00:Oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00?ooooo00?o
0000ooooooooool09oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Wooooo00?o
0000ooooooooool00oooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo00Gooooo00?o
0000ooooooooool02_ooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0:;ooooo000Y
ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0W
ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`03
ooooo`03o`000?oooooooooo02Oooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0:
ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0X_ooool002Wooooo00?o0000oooo
ooooool01oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo02Gooooo00?o0000oooo
ooooool01_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00;ooooo00?o0000oooo
ooooool09oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00[ooooo00?o0000oooo
ooooool00oooool00ol0003oooooooooo`2Qooooo`00:Oooool00ol0003oooooooooo`07ooooo`03
o`000?oooooooooo00Cooooo00?o0000ooooooooool09Oooool00ol0003oooooooooo`06ooooo`03
o`000?oooooooooo00_ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Uooooo`03
o`000?oooooooooo00Gooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`03ooooo`03
o`000?oooooooooo0:7ooooo000Yooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`0Uooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0
3?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo02Gooooo00?o0000ooooooooool0
1Oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
XOooool002Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo02Gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0<ooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool09Oooool00ol0003oooooooooo`05ooooo`03o`000?oo
oooooooo00cooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`2Pooooo`00:Oooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool08oooool0
0ol0003oooooooooo`06ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`0Uooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool03?ooool0
0ol0003oooooooooo`03ooooo`03o`000?oooooooooo0:3ooooo000Yooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Sooooo`03o`000?oooooooooo
00Kooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo
02?ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooooooool0X?ooool002Wooooo00?o0000ooooooooool02Oooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo02?ooooo00?o0000ooooooooool01Oooool00ol0003o
ooooooooo`0>ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool08oooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`2Pooooo`00:Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00?ooooo
00?o0000ooooooooool08oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00kooooo
00?o0000ooooooooool00oooool00ol0003oooooooooo`0Sooooo`03o`000?oooooooooo00Gooooo
00?o0000ooooooooool03_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo09oooooo
000Yooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool01?ooool00ol0003ooooooooo
o`0Rooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool03_ooool00ol0003ooooooooo
o`03ooooo`03o`000?oooooooooo02?ooooo00?o0000ooooooooool01?ooool00ol0003ooooooooo
o`0?ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0Woooool002Wooooo00?o0000
ooooooooool02Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo027ooooo00?o0000
ooooooooool01_ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00?ooooo00?o0000
ooooooooool08Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00oooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`2Oooooo`00:Oooool00ol0003oooooooooo`09oooo
o`03o`000?oooooooooo00Cooooo00?o0000ooooooooool08Oooool00ol0003oooooooooo`05oooo
o`03o`000?oooooooooo013ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Qoooo
o`03o`000?oooooooooo00Gooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`02oooo
o`03o`000?oooooooooo09oooooo000Yooooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`0Qooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool04?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo027ooooo00?o0000oooooooo
ool01Oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00?ooooo00?o0000oooooooo
ool0W_ooool002Wooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo023ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0@ooooo`03o`00
0?oooooooooo00?ooooo00?o0000ooooooooool08Oooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo017ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`2Nooooo`00:Ooo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool07ooo
ool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool04Ooo
ool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo09kooooo000Yooooo`03o`000?oooooo
oooo00[ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Oooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooo
oooo01oooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Booooo`03o`000?oooooo
oooo00;ooooo00?o0000ooooooooool0W_ooool002Wooooo00?o0000ooooooooool02oooool00ol0
003oooooooooo`03ooooo`03o`000?oooooooooo01oooooo00?o0000ooooooooool01Oooool00ol0
003oooooooooo`0Booooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool07oooool00ol0
003oooooooooo`04ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool00oooool00ol0
003oooooooooo`2Mooooo`00:Oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00Co
oooo00?o0000ooooooooool07_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo01;o
oooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo00Co
oooo00?o0000ooooooooool04oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo09go
oooo000Yooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`0Nooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool04oooool00ol0003ooooo
ooooo`04ooooo`03o`000?oooooooooo01gooooo00?o0000ooooooooool01Oooool00ol0003ooooo
ooooo`0Cooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0WOooool002Wooooo00?o
0000ooooooooool02oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo01gooooo00?o
0000ooooooooool01Oooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00Cooooo00?o
0000ooooooooool07Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo01Cooooo00?o
0000ooooooooool00oooool00ol0003oooooooooo`2Mooooo`00:Oooool00ol0003oooooooooo`0<
ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool07Oooool00ol0003oooooooooo`05
ooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0M
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool05Oooool00ol0003oooooooooo`03
ooooo`03o`000?oooooooooo09cooooo000Yooooo`03o`000?oooooooooo00cooooo00?o0000oooo
ooooool01?ooool00ol0003oooooooooo`0Looooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool05?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo01gooooo00?o0000oooo
ooooool01?ooool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo00?ooooo00?o0000oooo
ooooool0W?ooool002Wooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`04ooooo`03
o`000?oooooooooo01cooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Eooooo`03
o`000?oooooooooo00Cooooo00?o0000ooooooooool06oooool00ol0003oooooooooo`04ooooo`03
o`000?oooooooooo01Kooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`2Looooo`00
:Oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0
7?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo01Gooooo00?o0000ooooooooool0
1?ooool00ol0003oooooooooo`0Kooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0
5_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo09cooooo000Yooooo`03o`000?oo
oooooooo00cooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Kooooo`03o`000?oo
oooooooo00Gooooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo01_ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Gooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool0Voooool002Wooooo00?o0000ooooooooool03Oooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo01[ooooo00?o0000ooooooooool01Oooool0
0ol0003oooooooooo`0Fooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool06oooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`2Kooooo`00:Oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo
00Cooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
01Oooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Jooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo
09_ooooo000Jooooo`;o00000oooool3o`0000Oooooo00?o0000ooooooooool03Oooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo01[ooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`0Gooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool06Oooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`2Jooooo`006Oooool01?l0003oooooooooool00003ooooo`03o`000?oooooooooo00Ko
oooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo01[o
oooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo00Co
oooo00?o0000ooooooooool06Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo01So
oooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`2Jooooo`006?ooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo00Kooooo[Ol0002Aooooo`006?ooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool03_ooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool01?ooool00ol0003ooooooooo
o`0Iooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool06?ooool00ol0003ooooooooo
o`03ooooo`03o`000?oooooooooo01[ooooo00?o0000ooooooooool00oooool00ol0003ooooooooo
o`2Jooooo`006?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Kooooo00?o0000
ooooooooool03_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo01Sooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`0Iooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool06?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo01[ooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`2Iooooo`006Oooool01?l0003oooooooooool00002
ooooo`;o00002?ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool06?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo01Wooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool06_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo09Wooooo000Joooo
o`?o00000oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00kooooo00?o0000oooo
ooooool01Oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo00?ooooo00?o0000oooo
ooooool06oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo01Oooooo00?o0000oooo
ooooool01?ooool00ol0003oooooooooo`0Kooooo`03o`000?oooooooooo00?ooooo00?o0000oooo
ooooool0VOooool002Wooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`04ooooo`03
o`000?oooooooooo01Oooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Kooooo`03
o`000?oooooooooo00Cooooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`03ooooo`03
o`000?oooooooooo01cooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`2Iooooo`00
:Oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0
5_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo01_ooooo00?o0000ooooooooool0
1?ooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0
7?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo09Sooooo000Yooooo`03o`000?oo
oooooooo00oooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Fooooo`03o`000?oo
oooooooo00Cooooo00?o0000ooooooooool06oooool00ol0003oooooooooo`04ooooo`03o`000?oo
oooooooo01Kooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Looooo`03o`000?oo
oooooooo00Cooooo00?o0000ooooooooool0V?ooool002Wooooo00?o0000ooooooooool03oooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo01Kooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`0Looooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool05Oooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo01cooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`2Hooooo`00:Oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool05Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo
01gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooooooool07_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo
09Sooooo000Yooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`0Eooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool07Oooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`0Nooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0Uoooool002Wooooo
00?o0000ooooooooool04?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo01Cooooo
00?o0000ooooooooool00oooool00ol0003oooooooooo`0Nooooo`03o`000?oooooooooo00Cooooo
00?o0000ooooooooool05?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo01kooooo
00?o0000ooooooooool01?ooool00ol0003oooooooooo`2Gooooo`00:Oooool00ol0003ooooooooo
o`0@ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool05?ooool00ol0003ooooooooo
o`03ooooo`03o`000?oooooooooo01kooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`0Cooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool07_ooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo09Oooooo000Yooooo`03o`000?oooooooooo013ooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00?ooooo00?o0000
ooooooooool07oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo01;ooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`0Pooooo`03o`000?oooooooooo00?ooooo00?o0000
ooooooooool0Uoooool002Wooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`05oooo
o`03o`000?oooooooooo01?ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Ooooo
o`03o`000?oooooooooo00Cooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`03oooo
o`03o`000?oooooooooo023ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`2Foooo
o`00:Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool04_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo023ooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00?ooooo00?o0000oooooooo
ool08?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo09Kooooo000Yooooo`03o`00
0?oooooooooo017ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Booooo`03o`00
0?oooooooooo00?ooooo00?o0000ooooooooool08?ooool00ol0003oooooooooo`05ooooo`03o`00
0?oooooooooo017ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Pooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool0U_ooool002Wooooo00?o0000ooooooooool04Ooo
ool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool00ooo
ool00ol0003oooooooooo`0Pooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool04Ooo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo027ooooo00?o0000ooooooooool01Ooo
ool00ol0003oooooooooo`2Eooooo`00:Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooo
oooo02;ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooo
oooo00?ooooo00?o0000ooooooooool08_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooo
oooo09Gooooo000Yooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool01Oooool00ol0
003oooooooooo`0Aooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool08_ooool00ol0
003oooooooooo`04ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool00oooool00ol0
003oooooooooo`0Rooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0UOooool002Wo
oooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo013o
oooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Rooooo`03o`000?oooooooooo00Go
oooo00?o0000ooooooooool03oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo02;o
oooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`2Dooooo`00:Oooool00ol0003ooooo
ooooo`0Booooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool03oooool00ol0003ooooo
ooooo`03ooooo`03o`000?oooooooooo02;ooooo00?o0000ooooooooool01Oooool00ol0003ooooo
ooooo`0?ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool08oooool00ol0003ooooo
ooooo`05ooooo`03o`000?oooooooooo09Cooooo000Yooooo`03o`000?oooooooooo01;ooooo00?o
0000ooooooooool01Oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00;ooooo00?o
0000ooooooooool09?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00oooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`0Tooooo`03o`000?oooooooooo00Cooooo00?o
0000ooooooooool0U?ooool002Wooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`05
ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0T
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`03
ooooo`03o`000?oooooooooo02Cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`2C
ooooo`00:Oooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool03Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo02Cooooo00?o0000oooo
ooooool01Oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00?ooooo00?o0000oooo
ooooool09?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo09?ooooo000Yooooo`03
o`000?oooooooooo01?ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0=ooooo`03
o`000?oooooooooo00?ooooo00?o0000ooooooooool09?ooool00ol0003oooooooooo`05ooooo`03
o`000?oooooooooo00gooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Uooooo`03
o`000?oooooooooo00Gooooo00?o0000ooooooooool0Toooool002Wooooo00?o0000ooooooooool0
4oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool0
0_ooool00ol0003oooooooooo`0Vooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0
3Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo02Gooooo00?o0000ooooooooool0
1_ooool00ol0003oooooooooo`2Booooo`00:Oooool00ol0003oooooooooo`0Cooooo`03o`000?oo
oooooooo00Kooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`02ooooo`03o`000?oo
oooooooo02Kooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0=ooooo`03o`000?oo
oooooooo00;ooooo00?o0000ooooooooool09_ooool00ol0003oooooooooo`05ooooo`03o`000?oo
oooooooo09;ooooo000Yooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool01Oooool0
0ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool09_ooool0
0ol0003oooooooooo`05ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`0Wooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0T_ooool0
02Wooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
00_ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool02oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo
02Oooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`2Aooooo`00:Oooool00ol0003o
ooooooooo`0Dooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool02_ooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo02Sooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`0;ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool09oooool00ol0003o
ooooooooo`06ooooo`03o`000?oooooooooo097ooooo000Yooooo`03o`000?oooooooooo01Gooooo
00?o0000ooooooooool01Oooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00;ooooo
00?o0000ooooooooool0:?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo00Wooooo
00?o0000ooooooooool00oooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo00Kooooo
00?o0000ooooooooool0TOooool002Wooooo00?o0000ooooooooool05Oooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo00[ooooo00Go0000ooooooooooooooooo`00000[ooooo`03o`00
0?oooooooooo00Gooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`02ooooo`03o`00
0?oooooooooo02Wooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`2@ooooo`00:Ooo
ool00ol0003oooooooooo`0Eooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool02?oo
ool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo02Wooooo00?o0000ooooooooool01_oo
ool00ol0003oooooooooo`08ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0:Ooo
ool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo093ooooo000Yooooo`03o`000?oooooo
oooo01Gooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`08ooooo`03o`000?oooooo
oooo00;ooooo00?o0000ooooooooool0:_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooo
oooo00Sooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Yooooo`03o`000?oooooo
oooo00Kooooo00?o0000ooooooooool0T?ooool002Wooooo00?o0000ooooooooool05_ooool00ol0
003oooooooooo`06ooooo`03o`000?oooooooooo00Oooooo00Go0000ooooooooooooooooo`00000]
ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`02
ooooo`03o`000?oooooooooo02[ooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`2?
ooooo`00:Oooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo00Kooooo00?o0000oooo
ooooool01oooool01Ol0003ooooooooooooooooo000002gooooo00?o0000ooooooooool01_ooool0
0ol0003oooooooooo`06ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0:oooool0
0ol0003oooooooooo`06ooooo`03o`000?oooooooooo08oooooo000Yooooo`03o`000?oooooooooo
01Kooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`05ooooo`05o`000?oooooooooo
ooooool00000;_ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00Kooooo00Go0000
ooooooooooooooooo`00000^ooooo`03o`000?oooooooooo09Sooooo000Yooooo`03o`000?oooooo
oooo01Oooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`05ooooo`05o`000?oooooo
ooooooooool00000;_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Cooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`0/ooooo`03o`000?oooooooooo09Sooooo000Y
ooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`04
ooooo`04o`000?ooooooooooo`00033ooooo00?o0000ooooooooool01_ooool00ol0003ooooooooo
o`04ooooo`05o`000?ooooooooooooooool00000<?ooool00ol0003oooooooooo`2Gooooo`00:Ooo
ool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool00ooo
ool01Ol0003ooooooooooooooooo0000033ooooo00?o0000ooooooooool01oooool00ol0003ooooo
ooooo`03ooooo`05o`000?ooooooooooooooool00000<?ooool00ol0003oooooooooo`2Gooooo`00
:Oooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0
0_ooool01?l0003oooooooooool0000aooooo`03o`000?oooooooooo00Oooooo00?o0000oooooooo
ool00oooool01?l0003oooooooooool0000aooooo`03o`000?oooooooooo09Oooooo000Yooooo`03
o`000?oooooooooo01Sooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`02ooooo`03
o`000?oooooo000003;ooooo00?o0000ooooooooool02?ooool01Ol0003ooooooooooooooooo0000
00;ooooo00?o0000ooooooooool0<Oooool00ol0003oooooooooo`2Fooooo`00:Oooool00ol0003o
ooooooooo`0Hooooo`03o`000?oooooooooo00Sooooo0_l000000ooooooo0000ooooo`02o`0003?o
oooo00?o0000ooooooooool02?ooool2o`000004ooooool0003oooooo`0003Cooooo00?o0000oooo
ooooool0U_ooool002Wooooo00?o0000ooooooooool06Oooool00ol0003oooooooooo`08ooooo`Co
0000=Oooool00ol0003oooooooooo`09ooooo`Go0000=?ooool00ol0003oooooooooo`2Fooooo`00
:Oooool00ol0003oooooooooo`0Iooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0
=Oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo03Gooooo00?o0000ooooooooool0
UOooool002Wooooo00?o0000ooooooooool06Oooool00ol0003oooooooooo`09ooooo`03o`000?oo
oooooooo03Kooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0fooooo`03o`000?oo
oooooooo09Gooooo000Yooooo`03o`000?oooooooooo01[ooooo00?o0000ooooooooool02?ooool0
0ol0003oooooooooo`0fooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool0=_ooool0
0ol0003oooooooooo`2Eooooo`00:Oooool00ol0003oooooooooo`0Jooooo`03o`000?oooooooooo
00Oooooo00?o0000ooooooooool0=oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo
03Oooooo00?o0000ooooooooool0U?ooool002Wooooo00?o0000ooooooooool06_ooool00ol0003o
ooooooooo`07ooooo`03o`000?oooooooooo03Sooooo00?o0000ooooooooool01oooool00ol0003o
ooooooooo`0hooooo`03o`000?oooooooooo09Cooooo000Yooooo`03o`000?oooooooooo01_ooooo
00?o0000ooooooooool01Oooool00ol0003oooooooooo`0jooooo`03o`000?oooooooooo00Kooooo
00?o0000ooooooooool0>?ooool00ol0003oooooooooo`2Dooooo`00:Oooool00ol0003ooooooooo
o`0Looooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0>_ooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo03[ooooo00?o0000ooooooooool0Toooool002Wooooo00?o0000
ooooooooool07?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo03cooooo00?o0000
ooooooooool00oooool00ol0003oooooooooo`0looooo`03o`000?oooooooooo09;ooooo000Yoooo
o`03o`000?oooooooooo01gooooo0_l00002ooooo`03o`000?oooooooooo03kooooo00?o0000oooo
ooooool00_l00010ooooo`03o`000?oooooooooo097ooooo000Yooooo`03o`000?oooooooooo01ko
oooo0ol00012ooooo`?o0000@_ooool2o`00097ooooo000Yooooo`03o`000?oooooooooo0?oooooo
??ooool002Wooooo00?o0000ooooooooool0oooooollooooo`00:Oooool00ol0003oooooooooo`3o
oooooccooooo000Yooooo`03o`000?oooooooooo0?oooooo??ooool002Wooooo00?o0000oooooooo
ool0oooooollooooo`00:Oooool00ol0003oooooooooo`3ooooooccooooo000Yooooo`03o`000?oo
oooooooo0?oooooo??ooool002Wooooo00?o0000ooooooooool0oooooollooooo`00oooooomXoooo
o`00oooooomXooooo`00oooooomXooooo`00oooooomXooooo`00oooooomXooooo`00oooooomXoooo
o`00oooooomXooooo`003_ooool3o`0000?ooooo0ol00009ooooo`?o0000oooooom5ooooo`003ooo
ool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool00ooo
ool00ol0003oooooooooo`3oooooockooooo0002ooooo`Co00001?ooool2o`000003ooooool0003o
oooo00?o00000oooool3o`0000;ooooo1Ol00003ooooo`03o`000?oooooooooo00?ooooo00?o0000
ooooooooool00_ooool4o`0000;ooooo0ol00002ooooo`05o`000?oooooo0000ooooool000000_oo
ool4o`000005ooooool0003o0000o`000?ooool00_l000000ooooooo0000o`000002o`000?oooooo
6Oooool000Kooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00002ooooo`04
o`000?ooooooooooo`0000;ooooo00Go0000ooooooooooooooooo`000005ooooo`03o`000?oooooo
oooo00?ooooo00Go0000ooooooooooooooooo`000002ooooo`04o`000?ooooooooooo`0000Gooooo
00Oo0000ooooool0003oooooo`000?oooooo000000;ooooo00Go0000ooooooooooooooooo`000002
ooooo`03o`000?oooooo000000;ooooo00?o0000ooooooooool0oooooolHooooo`000oooool3o`00
00?ooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00002ooooo`04o`000?oo
ooooooooo`0000?ooooo00?o0000ooooooooool00_ooool00ol0003oooooo`000004ooooo`05o`00
0?ooooooooooooooool000000_ooool00ol0003oooooooooo`05o`000006ooooool0003oooooo`00
0?oooooo00000_ooool3o`0000?ooooo00Ko0000oooooooooooo0000ooooool00002ooooo`03o`00
0?oooooooooo0?oooooo6?ooool000;ooooo00?o0000ooooooooool01?ooool01?l0003ooooooooo
ool00002ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00000oooool00ol0
003oooooooooo`02ooooo`03o`000?oooooo000000Gooooo00Co0000oooooooooooo00000_ooool0
1?l0003oooooooooool00003ooooo`09o`000?oooooo0000ooooool0003oooooo`000?oooooo0000
00;ooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooo000000;ooooo00?o0000
ooooooooool0oooooolHooooo`000oooool4o`000004ooooool0003o0000ooooo`;o000000?ooooo
o`000?l000000_l00002ooooo`Co00001?ooool01?l0003oooooooooooooool2o`000003ooooool0
003o000000Cooooo00Co0000oooooooooooooooo0ol00003ooooo`?o00000_ooool2o`000003oooo
ool0003ooooo00;ooooo0_l00003ooooo`Co00000oooool3o`000?oooooo6_ooool001cooooo00?o
0000ooooooooool02oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo01_ooooo00?o
0000ooooooooool0oooooolHooooo`006_ooool3o`00017ooooo0_l0000Looooo`;o0000oooooolJ
ooooo`00oooooomXooooo`00oooooomXooooo`00oooooomXooooo`00oooooomXooooo`00oooooomX
ooooo`00oooooomXooooo`00oooooomXooooo`00oooooomXooooo`00oooooomXooooo`00oooooomX
ooooo`00oooooomXooooo`00oooooomXooooo`00oooooomXooooo`00oooooomXooooo`00oooooomX
ooooo`00oooooomXooooo`00oooooomXooooo`00oooooomXooooo`00oooooomXooooo`00oooooomX
ooooo`00oooooomXooooo`00oooooomXooooo`00oooooomXooooo`00oooooomXooooo`00oooooomX
ooooo`00oooooomXooooo`00\
\>"],
  ImageRangeCache->{{{0, 358.812}, {221.375, 0}} -> {-7.12882, 3.63355, \
0.173869, 0.0372757}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[p, 
      Graphics[Text["\<<-demand\>", {30.1, 9.95}, {\(-1\), 0}], 
        Text["\<<-supply\>", {30.1, 9.4}, {\(-1\), 0}]]]\)], "Input",
  AspectRatioFixed->True],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 0.025 -0.583051 0.11661 [
[.15 -0.0125 -3 -9 ]
[.15 -0.0125 3 0 ]
[.3 -0.0125 -6 -9 ]
[.3 -0.0125 6 0 ]
[.45 -0.0125 -6 -9 ]
[.45 -0.0125 6 0 ]
[.6 -0.0125 -6 -9 ]
[.6 -0.0125 6 0 ]
[.75 -0.0125 -6 -9 ]
[.75 -0.0125 6 0 ]
[1.025 0 0 -6 ]
[1.025 0 82 6 ]
[-0.0125 .34983 -16 -6 ]
[-0.0125 .34983 0 6 ]
[0 .64303 -41 0 ]
[0 .64303 41 12 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.15 0 m
.15 .00625 L
s
[(6)] .15 -0.0125 0 1 Mshowa
.3 0 m
.3 .00625 L
s
[(12)] .3 -0.0125 0 1 Mshowa
.45 0 m
.45 .00625 L
s
[(18)] .45 -0.0125 0 1 Mshowa
.6 0 m
.6 .00625 L
s
[(24)] .6 -0.0125 0 1 Mshowa
.75 0 m
.75 .00625 L
s
[(30)] .75 -0.0125 0 1 Mshowa
0 0 m
1 0 L
s
gsave
1.025 0 -61 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(Time) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
93.000 13.000 moveto
(H) show
99.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(months) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
135.000 13.000 moveto
(L) show
141.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 .34983 m
.00625 .34983 L
s
gsave
-0.0125 .34983 -77 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(C1) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
0 .61803 L
s
gsave
0 .64303 -102 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(supply) show
%%IncludeResource: font Mathematica2Mono
%%IncludeFont: Mathematica2Mono
/Mathematica2Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
99.000 13.000 moveto
(\\220) show
105.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(demand) show
141.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.004 w
0 .34983 m
.03043 .34983 L
.06361 .34983 L
.09477 .34983 L
.12474 .34983 L
.15664 .34983 L
.18735 .34983 L
.21998 .34983 L
.25143 .34983 L
.28168 .34983 L
.31386 .34983 L
.34485 .34983 L
.37465 .34983 L
.40637 .34983 L
.43691 .34983 L
.46937 .34983 L
.50064 .34983 L
.53072 .34983 L
.56273 .34983 L
.59354 .34983 L
.62629 .34983 L
.65784 .34983 L
.6882 .34983 L
.72049 .34983 L
.75 .34983 L
s
.007 w
0 .11661 m
.00093 .11665 L
.00177 .11677 L
.00274 .11699 L
.00366 .11729 L
.00529 .11804 L
.00707 .11916 L
.00902 .12076 L
.01109 .12288 L
.01481 .12774 L
.02224 .14146 L
.03043 .16238 L
.04756 .22304 L
.06361 .29471 L
.09414 .44083 L
.10966 .50465 L
.11786 .53218 L
.1266 .55561 L
.13098 .5648 L
.13511 .5718 L
.13881 .57668 L
.14072 .57866 L
.14282 .58042 L
.14377 .58107 L
.14479 .58166 L
.14567 .58209 L
.14663 .58247 L
.14719 .58265 L
.14771 .58278 L
.14874 .58297 L
.14967 .58305 L
.15066 .58303 L
.15151 .58293 L
.15243 .58275 L
.1533 .5825 L
.15409 .5822 L
.15593 .58125 L
.15787 .57989 L
.16181 .57595 L
.16539 .57104 L
.17342 .55555 L
.18086 .53601 L
.18788 .51341 L
.21818 .38305 L
.23352 .30843 L
.2504 .23153 L
.25813 .20069 L
.26643 .17191 L
.27421 .1498 L
.28143 .13403 L
Mistroke
.28529 .12758 L
.28941 .12233 L
.29176 .12007 L
.29397 .11847 L
.29494 .11792 L
.29596 .11744 L
.29649 .11724 L
.29708 .11705 L
.29811 .11679 L
.29862 .11671 L
.29917 .11665 L
.30018 .11661 L
.30116 .11668 L
.30206 .11683 L
.30304 .11708 L
.30412 .11748 L
.30524 .11801 L
.3063 .11864 L
.30998 .12168 L
.31204 .12399 L
.31394 .12647 L
.32168 .14023 L
.32887 .15795 L
.34518 .21346 L
.37597 .35457 L
.39168 .42966 L
.40869 .50107 L
.41667 .52849 L
.4251 .55206 L
.43231 .56722 L
.4364 .57365 L
.44022 .57817 L
.44226 .57999 L
.44415 .5813 L
.44522 .58188 L
.44623 .58232 L
.44728 .58267 L
.44783 .58281 L
.44843 .58293 L
.44938 .58303 L
.45041 .58304 L
.45093 .58301 L
.45149 .58294 L
.4525 .58273 L
.4535 .58242 L
.45445 .58204 L
.45623 .58107 L
.45799 .57979 L
.45987 .57809 L
.46323 .57415 L
Mistroke
.46685 .56868 L
.47083 .5612 L
.47882 .54183 L
.48613 .51941 L
.50257 .45539 L
.53386 .3068 L
.54965 .23472 L
.56395 .17998 L
.5714 .1572 L
.57946 .13786 L
.58389 .12976 L
.58797 .12398 L
.59186 .11999 L
.59382 .11856 L
.59494 .11792 L
.59598 .11744 L
.59694 .11709 L
.59796 .11682 L
.59898 .11666 L
.59956 .11662 L
.60011 .11661 L
.60109 .11667 L
.60199 .11681 L
.60298 .11706 L
.60402 .11744 L
.60584 .11835 L
.60752 .1195 L
.61135 .12317 L
.61553 .12884 L
.61932 .13544 L
.62783 .15511 L
.64295 .20476 L
.65933 .27465 L
.69157 .42914 L
.70761 .49702 L
.71545 .52462 L
.72261 .54573 L
.72939 .56166 L
.73582 .57284 L
.73934 .57726 L
.74261 .58026 L
.74449 .5815 L
.74619 .58231 L
.74713 .58263 L
.74815 .58288 L
.74912 .58301 L
.75 .58305 L
Mfstroke
.004 w
0 0 m
.03043 .08119 L
.06361 .17777 L
.09477 .30145 L
.12474 .42537 L
.14144 .48183 L
.14934 .50292 L
.15664 .51853 L
.16421 .53043 L
.1682 .53485 L
.17021 .53658 L
.17242 .5381 L
.17342 .53865 L
.17436 .53909 L
.17522 .53942 L
.17614 .53971 L
.17713 .53995 L
.17805 .54009 L
.17861 .54014 L
.17914 .54017 L
.18013 .54015 L
.18101 .54006 L
.18193 .5399 L
.18273 .53971 L
.1836 .53943 L
.18554 .53859 L
.18735 .53752 L
.19129 .53424 L
.19558 .52924 L
.20337 .51644 L
.21096 .49969 L
.21799 .48079 L
.24891 .37047 L
.27864 .25578 L
.29387 .2083 L
.30244 .18762 L
.30624 .18008 L
.3103 .17322 L
.31434 .16765 L
.31802 .16372 L
.31979 .16221 L
.32171 .16087 L
.32353 .15989 L
.3252 .15923 L
.32614 .15896 L
.32715 .15875 L
.3281 .15863 L
.32897 .15859 L
.32999 .15862 L
.33056 .15868 L
Mistroke
.3311 .15876 L
.33208 .15896 L
.33312 .15927 L
.33421 .15969 L
.33539 .16025 L
.33752 .16156 L
.3415 .16501 L
.34539 .16961 L
.34901 .17498 L
.35723 .19085 L
.36525 .21084 L
.37383 .23656 L
.40645 .35922 L
.42278 .42274 L
.43787 .47407 L
.45253 .51221 L
.45993 .52586 L
.46414 .53175 L
.46809 .536 L
.46989 .53751 L
.4718 .53883 L
.4729 .53945 L
.4739 .53993 L
.47485 .5403 L
.47585 .54062 L
.47635 .54074 L
.4769 .54086 L
.47787 .541 L
.47842 .54104 L
.479 .54106 L
.47955 .54105 L
.48006 .54102 L
.48103 .5409 L
.48158 .5408 L
.48209 .54069 L
.48302 .54041 L
.48402 .54005 L
.48573 .53922 L
.48759 .53805 L
.49094 .53521 L
.49494 .53064 L
.4986 .52533 L
.50631 .51085 L
.51348 .49359 L
.52978 .44309 L
.5605 .32428 L
.57616 .26458 L
.58441 .23642 L
.59315 .21028 L
.60094 .1909 L
Mistroke
.60507 .18231 L
.60952 .17446 L
.61359 .1686 L
.61731 .1644 L
.6191 .16278 L
.62106 .16131 L
.6229 .16021 L
.62461 .15944 L
.62563 .15911 L
.62618 .15896 L
.6267 .15884 L
.62761 .15869 L
.62862 .15861 L
.62918 .1586 L
.62971 .15862 L
.63071 .15871 L
.63126 .1588 L
.63178 .1589 L
.63294 .15922 L
.63388 .15956 L
.63475 .15994 L
.63675 .16105 L
.63869 .16245 L
.64079 .1643 L
.64451 .16848 L
.64844 .17407 L
.65544 .18698 L
.671 .22764 L
.68547 .2771 L
.71623 .39791 L
.74893 .50414 L
.75 .50663 L
Mfstroke
gsave
.7525 .57722 -61 -10 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 13.000 moveto
%%IncludeResource: font Mathematica1Mono
%%IncludeFont: Mathematica1Mono
/Mathematica1Mono findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(<) show
69.000 13.000 moveto
(-) show
75.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(demand) show
111.000 13.000 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  Evaluatable->False,
  AspectRatioFixed->False,
  ImageSize->{371.812, 229.812},
  ImageMargins->{{34, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005c0000iB000`400?l00000o`00003ooooooomd
ooooo`00Boooool3o`0001kooooo0ol00002ooooo`Go00006_ooool3o`0000?ooooo0ol0000Koooo
o`Go00000oooool3o`0001[ooooo0ol00004ooooo`;o0000TOooool004[ooooo00Go0000oooooooo
ooooooooo`00000Nooooo`03o`000?oooooooooo00;ooooo00Co0000oooooooooooo00006oooool0
1Ol0003ooooooooooooooooo000000?ooooo00?o0000ooooooooool06Oooool01?l0003ooooooooo
ool00004ooooo`03o`000?oooooooooo01Sooooo00Go0000ooooooooooooooooo`000002ooooo`04
o`000?ooooooooooo`00093ooooo001:ooooo`05o`000?ooooooooooooooool000007_ooool00ol0
003oooooooooo`03ooooo`03o`000?oooooooooo01_ooooo00Go0000ooooooooooooooooo`000003
ooooo`03o`000?oooooooooo01[ooooo00Co0000oooooooooooooooo1Ol0000Mooooo`04o`000?oo
ooooooooo`0000;ooooo00?o0000ooooooooool0S_ooool004[ooooo1?l0000Oooooo`03o`000?oo
oooooooo00Cooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`02ooooo`?o00007_oo
ool01?l0003oooooooooool00002ooooo`03o`000?oooooooooo01[ooooo0_l00003ooooo`04o`00
0?ooooooooooo`00093ooooo001:ooooo`03o`000?oooooooooo023ooooo00Go0000oooooooooooo
ooooo`000003ooooo`03o`000?oooooooooo01Wooooo00Go0000ooooooooooooooooo`000003oooo
o`03o`000?oooooooooo01Sooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooo
000001kooooo00Co0000oooooooooooo00000_ooool00ol0003oooooooooo`2>ooooo`00Boooool0
0ol0003oooooooooo`0Nooooo`;o00000oooool01Ol0003ooooooooooooooooo000001[ooooo0_l0
0003ooooo`05o`000?ooooooooooooooool000006_ooool01Ol0003ooooooooooooooooo000000?o
oooo0_l0000Jooooo`05o`000?ooooooooooooooool000000_ooool01?l0003oooooooooool0002@
ooooo`00C?ooool2o`0001oooooo00?o0000ooooooooool00_ooool3o`0001cooooo00?o0000oooo
ooooool00_ooool3o`0001cooooo0ol00005ooooo`03o`000?oooooooooo01Wooooo0ol00004oooo
o`;o0000TOooool00?ooooooM?ooool00?ooooooAOooool00ol0003oooooooooo`0Tooooo`03o`00
0?oooooooooo00Gooooo003oooooodCooooo00?o0000ooooooooool09_ooool00ol0003ooooooooo
o`04ooooo`00oooooolTooooo`?o00000_ooool5o`000006ooooool0003oooooo`000?oooooo0000
0_ooool3o`0000[ooooo00Wo0000ooooooooooooooooo`000?oooooo0000ooooool000000_ooool3
o`0000;ooooo0ol000000ooooooo0000o`000002ooooo`;o00000_ooool:o`0000Gooooo00?o0000
ooooooooool00oooool00?oooooo9Oooool00ol0003oooooooooo`03ooooo`0;o`000?oooooooooo
ooooool0003oooooo`000?oooooo0000ooooool000003Oooool02ol0003ooooooooooooooooo0000
ooooool0003oooooo`000?oooooo000000?ooooo00Co0000oooooooooooo00000_ooool01?l0003o
ooooooooool00002ooooo`04o`000?ooooooooooo`0000;ooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`02ooooo`03o`000?oooooooooo00?ooooo000Yoooooo;o00002Oooool00ol0
003oooooooooo`03ooooo`0:o`000?ooooooooooooooool0003oooooo`000?oooooo0000ooooo`Go
00002Oooool02ol0003ooooooooooooooooo0000ooooool0003oooooo`000?oooooo000000?ooooo
00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00005ooooo`04o`000?oooooooooo
o`0000;ooooo0ol00005ooooo`03o`000?oooooooooo00?ooooo000Yooooo`03o`000?oooooooooo
027ooooo00?o0000ooooooooool08Oooool00ol0003oooooooooo`0Qooooo`03o`000?oooooooooo
02;ooooo00?o0000ooooooooool08Oooool00ol0003oooooooooo`13ooooo`03o`000?oooooooooo
00?ooooo00_o0000ooooooooooooooooo`000?oooooo0000ooooool0003oooooo`000003ooooo`03
o`000?oooooooooo00Oooooo00_o0000ooooooooooooooooo`000?oooooo0000ooooool0003ooooo
o`000003ooooo`04o`000?ooooooooooo`0000;ooooo00Co0000oooooooooooo00001Oooool01_l0
003oooooooooool0003oooooo`0000Sooooo00?o0000ooooooooool00oooool002Wooooo00?o0000
ooooooooool08Oooool00ol0003oooooooooo`0Qooooo`03o`000?oooooooooo027ooooo00?o0000
ooooooooool08_ooool00ol0003oooooooooo`0Qooooo`03o`000?oooooooooo047ooooo00Ko0000
ooooool0003oooooo`000?ooool3o`0000?ooooo0_l000000ooooooo0000ooooo`02ooooo`?o0000
2oooool00ol0003oooooooooo`02o`000003ooooool0003ooooo00;ooooo0ol00002ooooo`Co0000
0_ooool4o`0000?ooooo0ol00003ooooo`Co00000oooool00ol0003oooooooooo`04ooooo`00:Ooo
ool2o`000?Oooooo00Go0000ooooool0003oooooo`00000Mooooo`03o`000?oooooooooo01;ooooo
00?o0000ooooooooool00oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00Gooooo
000Yooooo`;o0000moooool5o`0000?ooooo00?o0000ooooooooool0;?ooool00ol0003ooooooooo
o`02ooooo`;o00004oooool002Wooooo0_l0003oooooodWooooo000Yooooo`03o`000?oooooo0000
0?ooooooB?ooool002Wooooo00?o0000ooooool00000oooooom8ooooo`00:Oooool00ol0003ooooo
o`00003oooooodSooooo000Yooooo`03o`000?oooooo00000?ooooooB?ooool002Wooooo00Co0000
oooooooooooo0000oooooom7ooooo`00:Oooool01?l0003oooooooooool0003oooooodOooooo000Y
ooooo`04o`000?ooooooooooo`000?ooooooAoooool002Wooooo00Go0000ooooooooooooooooo`00
003oooooodKooooo000Yooooo`05o`000?ooooooooooooooool00000oooooom6ooooo`00:Oooool0
1Ol0003ooooooooooooooooo00000?ooooooA_ooool002Wooooo00Go0000ooooooooooooooooo`00
003oooooodKooooo000Yooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0oooooom3
ooooo`00:Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo0?oooooo@oooool002Wo
oooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`3ooooood?ooooo000Yooooo`03o`00
0?oooooooooo00;ooooo00?o0000ooooooooool0oooooom3ooooo`00:Oooool00ol0003ooooooooo
o`03ooooo`03o`000?oooooooooo0?oooooo@_ooool002Wooooo00?o0000ooooooooool00oooool0
0ol0003oooooooooo`3ooooood;ooooo000Yooooo`03o`000?oooooooooo00?ooooo00?o0000oooo
ooooool0oooooom2ooooo`00:Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo0?oo
oooo@Oooool002Wooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`3ooooood7ooooo
000Yooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0oooooom1ooooo`00:Oooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo0?oooooo@Oooool002Wooooo00?o0000oooo
ooooool01Oooool00ol0003oooooooooo`3ooooood3ooooo000Yooooo`03o`000?oooooooooo00Go
oooo00?o0000ooooooooool0oooooom0ooooo`00:Oooool00ol0003oooooooooo`05ooooo`03o`00
0?oooooooooo0?oooooo@?ooool002Wooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`3ooooood3ooooo000Yooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0oooooolo
ooooo`00:Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo0?oooooo?oooool002Wo
oooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`3oooooocoooooo000Yooooo`03o`00
0?oooooooooo00Kooooo00?o0000ooooooooool0ooooooloooooo`00:Oooool2o`0000Sooooo00?o
0000ooooooooool0>_ooool4o`0004Cooooo1?l0002gooooo`00:Oooool3o`0000Oooooo00?o0000
ooooooooool0>?ooool6o`0004Cooooo1?l0002gooooo`00:Oooool00ol0003oooooo`000007oooo
o`03o`000?oooooooooo03Sooooo0_l00003ooooo`;o0000@_ooool2o`0000;ooooo0_l0002foooo
o`00:Oooool01?l0003oooooo`000?l00006ooooo`03o`000?oooooooooo03Oooooo0_l00005oooo
o`03o`000?oooooooooo043ooooo00?o0000ooooooooool00_ooool2o`000;Gooooo000Yooooo`04
o`000?ooooooooooo`0000Oooooo00?o0000ooooooooool0=_ooool00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo03oooooo0_l00005ooooo`03o`000?oooooooooo0;?ooooo000Yooooo`03
o`000?oooooooooo00;o00001_ooool00ol0003oooooooooo`0fooooo`03o`000?oooooooooo00Co
oooo0_l00010ooooo`03o`000?oooooooooo00Cooooo0_l0002dooooo`00:Oooool01Ol0003ooooo
oooooooooooo000000Kooooo00?o0000ooooooooool0=_ooool00ol0003oooooooooo`05ooooo`03
o`000?oooooooooo03gooooo0_l00007ooooo`03o`000?oooooooooo0;;ooooo000Yooooo`04o`00
0?ooooooooooooooo`;o00001_ooool00ol0003oooooooooo`0dooooo`;o00001oooool2o`0003ko
oooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`2booooo`00:Oooool00ol0003ooooo
ooooo`02ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0=?ooool00ol0003ooooo
ooooo`07ooooo`03o`000?oooooooooo03_ooooo0_l00008ooooo`;o0000/oooool002Wooooo00?o
0000ooooooooool00_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo03Cooooo00?o
0000ooooooooool01oooool2o`0003cooooo00?o0000ooooooooool02?ooool00ol0003ooooooooo
o`2aooooo`00:Oooool00ol0003oooooooooo`02ooooo`;o00001Oooool00ol0003oooooooooo`0c
ooooo`;o00002_ooool00ol0003oooooooooo`0jooooo`03o`000?oooooooooo00Sooooo00?o0000
ooooooooool0/Oooool002Wooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo03;ooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`0ioooo
o`;o00002_ooool2o`000;;ooooo000Yooooo`03o`000?oooooooooo00?ooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`0booooo`03o`000?oooooooooo00Wooooo0_l0000jooooo`03
o`000?oooooooooo00[ooooo00?o0000ooooooooool0/?ooool002Wooooo00?o0000ooooooooool0
0oooool2o`0000Gooooo00?o0000ooooooooool0<Oooool2o`0000cooooo00?o0000ooooooooool0
>?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo0;3ooooo000Yooooo`03o`000?oo
oooooooo00Cooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0aooooo`03o`000?oo
oooooooo00[ooooo1?l0000hooooo`03o`000?oooooooooo00Wooooo1?l0002`ooooo`00:Oooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0<?ooool0
0ol0003oooooooooo`09ooooo`05o`000?oooooo0000ooooool00000=oooool2o`0000[ooooo1_l0
002_ooooo`00:Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool0;oooool2o`0000[ooooo00?o0000ooooooooool00_l000000ooooooo0000ooooo`0e
ooooo`03o`000?oooooooooo00Wooooo00Ko0000oooooooooooo0000ooooool0002_ooooo`00:Ooo
ool00ol0003oooooooooo`04ooooo`;o00001Oooool00ol0003oooooooooo`0_ooooo`03o`000?oo
oooooooo00Sooooo00?o0000ooooooooool00_ooool01?l0003oooooooooool0000eooooo`03o`00
0?oooooooooo00Sooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooooooo0:co
oooo000Yooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00oooool00ol0003ooooo
ooooo`0_ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool00_ooool01?l0003ooooo
ooooool0000eooooo`03o`000?oooooooooo00Sooooo00Go0000ooooooooooooooooo`000002oooo
o`03o`000?oooooooooo0:cooooo000Yooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool01?ooool00ol0003oooooooooo`0^ooooo`03o`000?oooooooooo00Sooooo00?o0000oooooooo
ool00_ooool01Ol0003ooooooooooooooooo000003?ooooo0_l00009ooooo`03o`000?oooooooooo
00;ooooo0_l00002ooooo`03o`000?oooooooooo0:_ooooo000Yooooo`03o`000?oooooooooo00Go
oooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0]ooooo`;o00002_ooool00ol0003o
ooooooooo`02ooooo`;o00000_ooool00ol0003oooooooooo`0aooooo`03o`000?oooooooooo00So
oooo00?o0000ooooooooool00oooool01?l0003oooooooooool0002]ooooo`00:Oooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0;Oooool00ol0003o
ooooooooo`08ooooo`03o`000?oooooooooo00Cooooo00Go0000ooooooooooooooooo`00000boooo
o`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01?ooool01Ol0003ooooooooooooooooo
00000:cooooo000Yooooo`03o`000?oooooooooo00Gooooo0_l00005ooooo`03o`000?oooooooooo
02gooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`04ooooo`05o`000?oooooooooo
ooooool00000<_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Cooooo00Go0000
ooooooooooooooooo`00002/ooooo`00:Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooo
oooo00?ooooo00?o0000ooooooooool0;Oooool00ol0003oooooooooo`07ooooo`03o`000?oooooo
oooo00Gooooo00Go0000ooooooooooooooooo`00000aooooo`;o00002?ooool00ol0003ooooooooo
o`05ooooo`;o00000oooool00ol0003oooooooooo`2Yooooo`00:Oooool00ol0003oooooooooo`06
ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0;?ooool00ol0003oooooooooo`07
ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0^
ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01_ooool01Ol0003ooooooooooooo
oooo00000:_ooooo000Yooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`0[ooooo`;o00002Oooool00ol0003oooooooooo`05ooooo`;o00000oooool0
0ol0003oooooooooo`0^ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01_ooool0
1Ol0003ooooooooooooooooo00000:_ooooo000Yooooo`03o`000?oooooooooo00Kooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`0[ooooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool01oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo02gooooo00?o0000
ooooooooool01_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00;ooooo00?o0000
ooooooooool0Z?ooool002Wooooo00?o0000ooooooooool01_ooool2o`0000Gooooo00?o0000oooo
ooooool0:oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Oooooo00?o0000oooo
ooooool00_ooool00ol0003oooooooooo`0/ooooo`;o00002?ooool00ol0003oooooooooo`07oooo
o`;o00000oooool00ol0003oooooooooo`2Xooooo`00:Oooool00ol0003oooooooooo`07ooooo`03
o`000?oooooooooo00?ooooo00?o0000ooooooooool0:oooool00ol0003oooooooooo`07ooooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0/ooooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool02?ooool01Ol0003ooooooooooooooooo0000
0:[ooooo000Yooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`0Yooooo`;o00002?ooool00ol0003oooooooooo`08ooooo`;o00001?ooool00ol0003o
ooooooooo`0[ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool02Oooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo0:Oooooo000Yooooo`03o`000?oooooooooo00Oooooo
00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Yooooo`03o`000?oooooooooo00Oooooo
00?o0000ooooooooool02Oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo02_ooooo
00?o0000ooooooooool01_ooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00;ooooo
00?o0000ooooooooool0Yoooool002Wooooo00?o0000ooooooooool01oooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo02Wooooo00?o0000ooooooooool01oooool00ol0003ooooooooo
o`09ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0:oooool00ol0003ooooooooo
o`06ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool00_ooool00ol0003ooooooooo
o`2Wooooo`00:Oooool00ol0003oooooooooo`07ooooo`;o00001Oooool00ol0003oooooooooo`0Y
ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`02
ooooo`03o`000?oooooooooo02[ooooo0_l00008ooooo`03o`000?oooooooooo00Wooooo0_l00004
ooooo`03o`000?oooooooooo0:Kooooo000Yooooo`03o`000?oooooooooo00Sooooo00?o0000oooo
ooooool00oooool00ol0003oooooooooo`0Yooooo`03o`000?oooooooooo00Kooooo00?o0000oooo
ooooool02_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo02Wooooo00?o0000oooo
ooooool01_ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00;ooooo00?o0000oooo
ooooool0Y_ooool002Wooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`03ooooo`03
o`000?oooooooooo02Sooooo0_l00008ooooo`03o`000?oooooooooo00[ooooo0_l00004ooooo`03
o`000?oooooooooo02Wooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0;ooooo`03
o`000?oooooooooo00;ooooo00?o0000ooooooooool0Y_ooool002Wooooo00?o0000ooooooooool0
2?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo02Oooooo00?o0000ooooooooool0
1oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0
:Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`2Uooooo`00:Oooool00ol0003oooooooooo`08ooooo`03o`000?oo
oooooooo00Cooooo00?o0000ooooooooool09oooool00ol0003oooooooooo`07ooooo`03o`000?oo
oooooooo00_ooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0Xooooo`;o00002?oo
ool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0YOoo
ool002Wooooo00?o0000ooooooooool02?ooool2o`0000Gooooo00?o0000ooooooooool09oooool0
0ol0003oooooooooo`06ooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`0Xooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool02oooool2
o`0000Cooooo00?o0000ooooooooool0YOooool002Wooooo00?o0000ooooooooool02Oooool00ol0
003oooooooooo`03ooooo`03o`000?oooooooooo02Oooooo00?o0000ooooooooool01_ooool00ol0
003oooooooooo`0<ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool09oooool00ol0
003oooooooooo`06ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool00_ooool00ol0
003oooooooooo`2Uooooo`00:Oooool00ol0003oooooooooo`09ooooo`03o`000?oooooooooo00?o
oooo00?o0000ooooooooool09oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00co
oooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo00Ko
oooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo0:Co
oooo000Yooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool01?ooool00ol0003ooooo
ooooo`0Uooooo`;o00001oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00?ooooo
00?o0000ooooooooool09oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00gooooo
00?o0000ooooooooool00oooool00ol0003oooooooooo`2Tooooo`00:Oooool00ol0003ooooooooo
o`09ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool09Oooool00ol0003ooooooooo
o`06ooooo`03o`000?oooooooooo00gooooo0_l00004ooooo`03o`000?oooooooooo02Oooooo00?o
0000ooooooooool01_ooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00?ooooo00?o
0000ooooooooool0Y?ooool002Wooooo00?o0000ooooooooool02Oooool00ol0003oooooooooo`04
ooooo`03o`000?oooooooooo02Gooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0>
ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool09Oooool2o`0000Oooooo00?o0000
ooooooooool03_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo0:Cooooo000Yoooo
o`03o`000?oooooooooo00Wooooo0_l00005ooooo`03o`000?oooooooooo02Gooooo00?o0000oooo
ooooool01_ooool00ol0003oooooooooo`0>ooooo`03o`000?oooooooooo00?ooooo00?o0000oooo
ooooool09Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00kooooo0_l00004oooo
o`03o`000?oooooooooo0:Cooooo000Yooooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`0Uooooo`03o`000?oooooooooo00Gooooo00?o0000oooooooo
ool03oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo02Gooooo00?o0000oooooooo
ool01_ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00?ooooo00?o0000oooooooo
ool0Xoooool002Wooooo00?o0000ooooooooool02_ooool00ol0003oooooooooo`03ooooo`03o`00
0?oooooooooo02Gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0?ooooo`03o`00
0?oooooooooo00?ooooo00?o0000ooooooooool09Oooool00ol0003oooooooooo`06ooooo`03o`00
0?oooooooooo00oooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`2Sooooo`00:Ooo
ool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool08ooo
ool2o`0000Oooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo02Gooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0?ooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool0Xoooool002Wooooo00?o0000ooooooooool02_ooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo02?ooooo00?o0000ooooooooool01_ooool0
0ol0003oooooooooo`0?ooooo`;o00001Oooool00ol0003oooooooooo`0Tooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool04?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooo
oooo0:?ooooo000Yooooo`03o`000?oooooooooo00[ooooo0_l00005ooooo`03o`000?oooooooooo
02?ooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo
00?ooooo00?o0000ooooooooool09?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
013ooooo0_l00004ooooo`03o`000?oooooooooo0:?ooooo000Yooooo`03o`000?oooooooooo00_o
oooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Sooooo`03o`000?oooooooooo00Go
oooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo02?o
oooo0_l00007ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`2Rooooo`00:Oooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo00?ooooo
00?o0000ooooooooool08oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo017ooooo
00?o0000ooooooooool00oooool00ol0003oooooooooo`0Sooooo`03o`000?oooooooooo00Kooooo
00?o0000ooooooooool04Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo0:;ooooo
000Yooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool00oooool00ol0003ooooooooo
o`0Sooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool04Oooool00ol0003ooooooooo
o`03ooooo`03o`000?oooooooooo02?ooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`0Booooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0X_ooool002Wooooo00?o0000
ooooooooool02oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo027ooooo0_l00007
ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0R
ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`03
ooooo`03o`000?oooooooooo0:;ooooo000Yooooo`03o`000?oooooooooo00_ooooo00?o0000oooo
ooooool01?ooool00ol0003oooooooooo`0Qooooo`03o`000?oooooooooo00Kooooo00?o0000oooo
ooooool04Oooool2o`0000Gooooo00?o0000ooooooooool08_ooool00ol0003oooooooooo`05oooo
o`03o`000?oooooooooo01;ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`2Roooo
o`00:Oooool00ol0003oooooooooo`0;ooooo`;o00001Oooool00ol0003oooooooooo`0Qooooo`03
o`000?oooooooooo00Gooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`03ooooo`03
o`000?oooooooooo02;ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Booooo`;o
00001Oooool00ol0003oooooooooo`2Qooooo`00:Oooool00ol0003oooooooooo`0<ooooo`03o`00
0?oooooooooo00?ooooo00?o0000ooooooooool08Oooool00ol0003oooooooooo`05ooooo`03o`00
0?oooooooooo01?ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Rooooo`03o`00
0?oooooooooo00Gooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`03ooooo`03o`00
0?oooooooooo0:7ooooo000Yooooo`03o`000?oooooooooo00cooooo00?o0000ooooooooool00ooo
ool00ol0003oooooooooo`0Qooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool04ooo
ool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo02;ooooo00?o0000ooooooooool01?oo
ool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0XOoo
ool002Wooooo00?o0000ooooooooool03?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooo
oooo023ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Cooooo`03o`000?oooooo
oooo00Cooooo00?o0000ooooooooool08?ooool2o`0000Kooooo00?o0000ooooooooool05?ooool0
0ol0003oooooooooo`03ooooo`03o`000?oooooooooo0:7ooooo000Yooooo`03o`000?oooooooooo
00cooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Oooooo`;o00001oooool00ol0
003oooooooooo`0Cooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool08?ooool00ol0
003oooooooooo`05ooooo`03o`000?oooooooooo01Cooooo00?o0000ooooooooool00oooool00ol0
003oooooooooo`2Qooooo`00:Oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00Co
oooo00?o0000ooooooooool07oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo01Co
oooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Pooooo`03o`000?oooooooooo00Go
oooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo0:3o
oooo000Yooooo`03o`000?oooooooooo00cooooo0_l00005ooooo`03o`000?oooooooooo01oooooo
00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Dooooo`;o00001Oooool00ol0003ooooo
ooooo`0Pooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool05Oooool2o`0000Gooooo
00?o0000ooooooooool0X?ooool002Wooooo00?o0000ooooooooool03Oooool00ol0003ooooooooo
o`03ooooo`03o`000?oooooooooo01oooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`0Eooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool08?ooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo01Kooooo00?o0000ooooooooool00oooool00ol0003ooooooooo
o`2Pooooo`00:Oooool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool07_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo01Gooooo00?o0000
ooooooooool01?ooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool05_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo0:3ooooo000Yoooo
o`03o`000?oooooooooo00gooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Noooo
o`03o`000?oooooooooo00Gooooo00?o0000ooooooooool05Oooool00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo01oooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Foooo
o`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0X?ooool002Wooooo00?o0000oooooooo
ool03Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo01gooooo0_l00006ooooo`03
o`000?oooooooooo01Kooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Nooooo`;o
00001_ooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool0Woooool002Wooooo00?o0000ooooooooool03Oooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo01gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Fooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool07_ooool00ol0003oooooooooo`04ooooo`03o`00
0?oooooooooo01Oooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`2Oooooo`00:Ooo
ool00ol0003oooooooooo`0=ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool07Ooo
ool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo01Kooooo0_l00005ooooo`03o`000?oo
oooooooo01kooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Gooooo`;o00001Ooo
ool00ol0003oooooooooo`2Oooooo`00:Oooool00ol0003oooooooooo`0=ooooo`;o00001_ooool0
0ol0003oooooooooo`0Looooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool05oooool0
0ol0003oooooooooo`04ooooo`03o`000?oooooooooo01gooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`0Hooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0Woooool0
02Wooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
01cooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo
00Cooooo00?o0000ooooooooool07Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
01Sooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`2Oooooo`00:Oooool00ol0003o
ooooooooo`0>ooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool07?ooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`0Mooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool06?ooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo09kooooo000Yooooo`03o`000?oooooooooo00kooooo
00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Kooooo`;o00001_ooool00ol0003ooooo
ooooo`0Hooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool07?ooool2o`0000Gooooo
00?o0000ooooooooool06Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo09kooooo
000Yooooo`03o`000?oooooooooo00kooooo00?o0000ooooooooool01?ooool00ol0003ooooooooo
o`0Kooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool06?ooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo01cooooo00?o0000ooooooooool01?ooool00ol0003ooooooooo
o`0Iooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0W_ooool002Wooooo00?o0000
ooooooooool03_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo01[ooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo00Gooooo00?o0000
ooooooooool06oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo01Wooooo0_l00005
ooooo`03o`000?oooooooooo09kooooo000Jooooo`;o00000oooool3o`0000Oooooo00?o0000oooo
ooooool03_ooool2o`0000Kooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`05oooo
o`03o`000?oooooooooo01Sooooo0_l00006ooooo`03o`000?oooooooooo01_ooooo00?o0000oooo
ooooool01?ooool00ol0003oooooooooo`0Jooooo`03o`000?oooooooooo00?ooooo00?o0000oooo
ooooool0W_ooool001Wooooo00Co0000oooooooooooo00000oooool00ol0003oooooooooo`06oooo
o`03o`000?oooooooooo00oooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Joooo
o`03o`000?oooooooooo00Cooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`04oooo
o`03o`000?oooooooooo01_ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Joooo
o`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0WOooool001Sooooo00?o0000oooooooo
ool01Oooool00ol0003oooooooooo`06oooookKo0000U?ooool001Sooooo00?o0000ooooooooool0
1Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00oooooo00?o0000ooooooooool0
1?ooool00ol0003oooooooooo`0Iooooo`;o00001_ooool00ol0003oooooooooo`0Jooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool06_ooool2o`0000Gooooo00?o0000ooooooooool0
6oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo09gooooo000Hooooo`03o`000?oo
oooooooo00Gooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0?ooooo`03o`000?oo
oooooooo00Gooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`05ooooo`03o`000?oo
oooooooo01[ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Iooooo`03o`000?oo
oooooooo00Cooooo00?o0000ooooooooool06oooool00ol0003oooooooooo`04ooooo`03o`000?oo
oooooooo09gooooo000Iooooo`04o`000?ooooooooooo`0000;ooooo0_l00008ooooo`03o`000?oo
oooooooo00oooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Hooooo`03o`000?oo
oooooooo00Gooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`05ooooo`03o`000?oo
oooooooo01Wooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Kooooo`03o`000?oo
oooooooo00Cooooo00?o0000ooooooooool0WOooool001[ooooo0ol00003ooooo`03o`000?oooooo
oooo00Kooooo00?o0000ooooooooool03oooool00ol0003oooooooooo`05ooooo`03o`000?oooooo
oooo01Sooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Kooooo`;o00001_ooool0
0ol0003oooooooooo`0Iooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool06oooool2
o`0000Kooooo00?o0000ooooooooool0W?ooool002Wooooo00?o0000ooooooooool03oooool2o`00
00Kooooo00?o0000ooooooooool06?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
01cooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Iooooo`03o`000?oooooooooo
00Cooooo00?o0000ooooooooool07?ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
09cooooo000Yooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool01?ooool00ol0003o
ooooooooo`0Hooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool07?ooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo01Sooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`0Mooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool0W?ooool002Wooooo
00?o0000ooooooooool04?ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo01Kooooo
0_l00006ooooo`03o`000?oooooooooo01cooooo00?o0000ooooooooool01Oooool00ol0003ooooo
ooooo`0Gooooo`;o00001Oooool00ol0003oooooooooo`0Mooooo`03o`000?oooooooooo00Cooooo
00?o0000ooooooooool0W?ooool002Wooooo00?o0000ooooooooool04?ooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo01Kooooo00?o0000ooooooooool01Oooool00ol0003ooooooooo
o`0Looooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool05oooool00ol0003ooooooooo
o`04ooooo`03o`000?oooooooooo01gooooo00?o0000ooooooooool01?ooool00ol0003ooooooooo
o`2Looooo`00:Oooool00ol0003oooooooooo`0@ooooo`03o`000?oooooooooo00Gooooo00?o0000
ooooooooool05_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo01gooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo00Cooooo00?o0000
ooooooooool07Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo09_ooooo000Yoooo
o`03o`000?oooooooooo013ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Foooo
o`03o`000?oooooooooo00Cooooo00?o0000ooooooooool07Oooool2o`0000Kooooo00?o0000oooo
ooooool05oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo01gooooo0_l00006oooo
o`03o`000?oooooooooo09_ooooo000Yooooo`03o`000?oooooooooo013ooooo00?o0000oooooooo
ool01Oooool00ol0003oooooooooo`0Fooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool07_ooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo01Kooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool0Voooool002Wooooo00?o0000ooooooooool04?ooool2o`0000Oooooo00?o0000ooooooooool0
5Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo01kooooo00?o0000ooooooooool0
1Oooool00ol0003oooooooooo`0Eooooo`;o00001Oooool00ol0003oooooooooo`0Oooooo`03o`00
0?oooooooooo00Cooooo00?o0000ooooooooool0Voooool002Wooooo00?o0000ooooooooool04Ooo
ool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo01Cooooo0_l00006ooooo`03o`000?oo
oooooooo01kooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Eooooo`03o`000?oo
oooooooo00Cooooo00?o0000ooooooooool07oooool00ol0003oooooooooo`04ooooo`03o`000?oo
oooooooo09_ooooo000Yooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool01Oooool0
0ol0003oooooooooo`0Dooooo`03o`000?oooooooooo00Cooooo00?o0000ooooooooool07oooool0
0ol0003oooooooooo`05ooooo`03o`000?oooooooooo01Gooooo00?o0000ooooooooool01?ooool0
0ol0003oooooooooo`0Oooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0V_ooool0
02Wooooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo
01Cooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Oooooo`03o`000?oooooooooo
00Gooooo00?o0000ooooooooool05Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo
01oooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`2Jooooo`00:Oooool00ol0003o
ooooooooo`0Aooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool05?ooool00ol0003o
ooooooooo`04ooooo`03o`000?oooooooooo01oooooo0_l00007ooooo`03o`000?oooooooooo01Co
oooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Pooooo`;o00001_ooool00ol0003o
ooooooooo`2Jooooo`00:Oooool00ol0003oooooooooo`0Aooooo`03o`000?oooooooooo00Kooooo
00?o0000ooooooooool04oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo023ooooo
00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Dooooo`03o`000?oooooooooo00?ooooo
00?o0000ooooooooool08Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo09[ooooo
000Yooooo`03o`000?oooooooooo017ooooo0_l00007ooooo`03o`000?oooooooooo01?ooooo00?o
0000ooooooooool00oooool00ol0003oooooooooo`0Qooooo`03o`000?oooooooooo00Gooooo00?o
0000ooooooooool04oooool2o`0000Gooooo00?o0000ooooooooool08Oooool00ol0003ooooooooo
o`05ooooo`03o`000?oooooooooo09Wooooo000Yooooo`03o`000?oooooooooo01;ooooo00?o0000
ooooooooool01Oooool00ol0003oooooooooo`0Booooo`;o00001Oooool00ol0003oooooooooo`0Q
ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool04oooool00ol0003oooooooooo`04
ooooo`03o`000?oooooooooo027ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`2I
ooooo`00:Oooool00ol0003oooooooooo`0Booooo`03o`000?oooooooooo00Gooooo00?o0000oooo
ooooool04_ooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo027ooooo00?o0000oooo
ooooool01Oooool00ol0003oooooooooo`0Cooooo`03o`000?oooooooooo00Cooooo00?o0000oooo
ooooool08Oooool00ol0003oooooooooo`05ooooo`03o`000?oooooooooo09Wooooo000Yooooo`03
o`000?oooooooooo01;ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0Booooo`03
o`000?oooooooooo00Cooooo00?o0000ooooooooool08Oooool00ol0003oooooooooo`06ooooo`03
o`000?oooooooooo01;ooooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Qooooo`03
o`000?oooooooooo00Gooooo00?o0000ooooooooool0VOooool002Wooooo00?o0000ooooooooool0
4_ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool0
0oooool00ol0003oooooooooo`0Rooooo`;o00001oooool00ol0003oooooooooo`0Booooo`03o`00
0?oooooooooo00?ooooo00?o0000ooooooooool08_ooool2o`0000Oooooo00?o0000ooooooooool0
V?ooool002Wooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`06ooooo`03o`000?oo
oooooooo017ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Sooooo`03o`000?oo
oooooooo00Gooooo00?o0000ooooooooool04_ooool00ol0003oooooooooo`03ooooo`03o`000?oo
oooooooo02?ooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`2Hooooo`00:Oooool0
0ol0003oooooooooo`0Booooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool04Oooool0
0ol0003oooooooooo`03ooooo`03o`000?oooooooooo02?ooooo00?o0000ooooooooool01Oooool0
0ol0003oooooooooo`0Aooooo`;o00001Oooool00ol0003oooooooooo`0Sooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool0V?ooool002Wooooo00?o0000ooooooooool04_ooool2o`00
00Oooooo00?o0000ooooooooool04?ooool2o`0000Gooooo00?o0000ooooooooool08oooool00ol0
003oooooooooo`05ooooo`03o`000?oooooooooo017ooooo00?o0000ooooooooool01?ooool00ol0
003oooooooooo`0Sooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0V?ooool002Wo
oooo00?o0000ooooooooool04oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00oo
oooo00?o0000ooooooooool01?ooool00ol0003oooooooooo`0Sooooo`03o`000?oooooooooo00Go
oooo00?o0000ooooooooool04Oooool00ol0003oooooooooo`04ooooo`03o`000?oooooooooo02?o
oooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`2Gooooo`00:Oooool00ol0003ooooo
ooooo`0Cooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool03oooool00ol0003ooooo
ooooo`03ooooo`03o`000?oooooooooo02Cooooo00?o0000ooooooooool01_ooool00ol0003ooooo
ooooo`0@ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool09?ooool00ol0003ooooo
ooooo`06ooooo`03o`000?oooooooooo09Oooooo000Yooooo`03o`000?oooooooooo01?ooooo00?o
0000ooooooooool01_ooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00?ooooo00?o
0000ooooooooool09?ooool2o`0000Oooooo00?o0000ooooooooool04?ooool00ol0003ooooooooo
o`03ooooo`03o`000?oooooooooo02Cooooo0_l00007ooooo`03o`000?oooooooooo09Oooooo000Y
ooooo`03o`000?oooooooooo01?ooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0?
ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool09Oooool00ol0003oooooooooo`05
ooooo`03o`000?oooooooooo013ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0U
ooooo`03o`000?oooooooooo00Gooooo00?o0000ooooooooool0Uoooool002Wooooo00?o0000oooo
ooooool04oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00kooooo0_l00005oooo
o`03o`000?oooooooooo02Gooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`0?oooo
o`;o00001Oooool00ol0003oooooooooo`0Uooooo`03o`000?oooooooooo00Kooooo00?o0000oooo
ooooool0U_ooool002Wooooo00?o0000ooooooooool04oooool2o`0000Sooooo00?o0000oooooooo
ool03Oooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo02Kooooo00?o0000oooooooo
ool01Oooool00ol0003oooooooooo`0?ooooo`03o`000?oooooooooo00Cooooo00?o0000oooooooo
ool09Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo09Kooooo000Yooooo`03o`00
0?oooooooooo01Cooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`0=ooooo`03o`00
0?oooooooooo00?ooooo00?o0000ooooooooool09_ooool00ol0003oooooooooo`06ooooo`03o`00
0?oooooooooo00kooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Vooooo`03o`00
0?oooooooooo00Kooooo00?o0000ooooooooool0U_ooool002Wooooo00?o0000ooooooooool05?oo
ool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool00ooo
ool00ol0003oooooooooo`0Vooooo`;o00001oooool00ol0003oooooooooo`0>ooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool09_ooool2o`0000Oooooo00?o0000ooooooooool0U_oo
ool002Wooooo00?o0000ooooooooool05?ooool00ol0003oooooooooo`06ooooo`03o`000?oooooo
oooo00gooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Wooooo`03o`000?oooooo
oooo00Gooooo00?o0000ooooooooool03_ooool00ol0003oooooooooo`03ooooo`03o`000?oooooo
oooo02Oooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`2Fooooo`00:Oooool00ol0
003oooooooooo`0Dooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool03?ooool00ol0
003oooooooooo`02ooooo`03o`000?oooooooooo02Sooooo00?o0000ooooooooool01Oooool00ol0
003oooooooooo`0=ooooo`;o00001Oooool00ol0003oooooooooo`0Wooooo`03o`000?oooooooooo
00Kooooo00?o0000ooooooooool0UOooool002Wooooo00?o0000ooooooooool05?ooool2o`0000So
oooo00?o0000ooooooooool02oooool2o`0000Cooooo00?o0000ooooooooool0:?ooool00ol0003o
ooooooooo`05ooooo`03o`000?oooooooooo00gooooo00?o0000ooooooooool00oooool00ol0003o
ooooooooo`0Xooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0UOooool002Wooooo
00?o0000ooooooooool05Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00_ooooo
00?o0000ooooooooool00oooool00ol0003oooooooooo`0Xooooo`03o`000?oooooooooo00Kooooo
00?o0000ooooooooool03?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooooooo02Sooooo
00?o0000ooooooooool01_ooool00ol0003oooooooooo`2Eooooo`00:Oooool00ol0003ooooooooo
o`0Eooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool02oooool00ol0003ooooooooo
o`03ooooo`03o`000?oooooooooo02Sooooo00?o0000ooooooooool01_ooool00ol0003ooooooooo
o`0<ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0:?ooool2o`0000Oooooo00?o
0000ooooooooool0UOooool002Wooooo00?o0000ooooooooool05Oooool00ol0003oooooooooo`06
ooooo`03o`000?oooooooooo00_ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0X
ooooo`;o00001oooool00ol0003oooooooooo`0<ooooo`03o`000?oooooooooo00?ooooo00?o0000
ooooooooool0:Oooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo09Cooooo000Yoooo
o`03o`000?oooooooooo01Gooooo00?o0000ooooooooool01oooool00ol0003oooooooooo`0:oooo
o`03o`000?oooooooooo00;ooooo00?o0000ooooooooool0:_ooool00ol0003oooooooooo`05oooo
o`03o`000?oooooooooo00_ooooo0_l00004ooooo`03o`000?oooooooooo02[ooooo00?o0000oooo
ooooool01_ooool00ol0003oooooooooo`2Dooooo`00:Oooool00ol0003oooooooooo`0Eooooo`;o
00002?ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00;ooooo00?o0000oooooooo
ool0:_ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool00oooool00ol0003oooooooooo`0Zooooo`03o`000?oooooooooo00Kooooo00?o0000oooooooo
ool0U?ooool002Wooooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`06ooooo`03o`00
0?oooooooooo00Wooooo0_l00004ooooo`03o`000?oooooooooo02[ooooo00?o0000ooooooooool0
1_ooool00ol0003oooooooooo`0:ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool0
:_ooool00ol0003oooooooooo`06ooooo`03o`000?oooooooooo09Cooooo000Yooooo`03o`000?oo
oooooooo01Kooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`09ooooo`03o`000?oo
oooooooo00?ooooo00?o0000ooooooooool0:_ooool00ol0003oooooooooo`06ooooo`03o`000?oo
oooooooo00[ooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`0Zooooo`;o00002?oo
ool00ol0003oooooooooo`2Cooooo`00:Oooool00ol0003oooooooooo`0Fooooo`03o`000?oooooo
oooo00Oooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`03ooooo`03o`000?oooooo
oooo02[ooooo0_l00008ooooo`03o`000?oooooooooo00Wooooo00?o0000ooooooooool00_ooool0
0ol0003oooooooooo`0/ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool0Toooool0
02Wooooo00?o0000ooooooooool05_ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo
00Sooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0/ooooo`03o`000?oooooooooo
00Kooooo00?o0000ooooooooool02?ooool2o`0000Cooooo00?o0000ooooooooool0;?ooool00ol0
003oooooooooo`06ooooo`03o`000?oooooooooo09?ooooo000Yooooo`03o`000?oooooooooo01Ko
oooo0_l00008ooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool00_ooool00ol0003o
ooooooooo`0/ooooo`03o`000?oooooooooo00Kooooo00?o0000ooooooooool02?ooool00ol0003o
ooooooooo`03ooooo`03o`000?oooooooooo02cooooo00?o0000ooooooooool01_ooool00ol0003o
ooooooooo`2Cooooo`00:Oooool00ol0003oooooooooo`0Gooooo`03o`000?oooooooooo00Oooooo
00?o0000ooooooooool01oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo02cooooo
00?o0000ooooooooool01oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00;ooooo
00?o0000ooooooooool0;Oooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo09;ooooo
000Yooooo`03o`000?oooooooooo01Oooooo00?o0000ooooooooool01oooool00ol0003ooooooooo
o`06ooooo`;o00001?ooool00ol0003oooooooooo`0/ooooo`03o`000?oooooooooo00Oooooo00?o
0000ooooooooool01oooool00ol0003oooooooooo`02ooooo`03o`000?oooooooooo02gooooo00?o
0000ooooooooool01oooool00ol0003oooooooooo`2Booooo`00:Oooool00ol0003oooooooooo`0G
ooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01_ooool00ol0003oooooooooo`02
ooooo`03o`000?oooooooooo02gooooo0_l00008ooooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool00_ooool00ol0003oooooooooo`0]ooooo`03o`000?oooooooooo00Oooooo00?o0000
ooooooooool0T_ooool002Wooooo00?o0000ooooooooool05oooool00ol0003oooooooooo`07oooo
o`03o`000?oooooooooo00Kooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0^oooo
o`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01Oooool2o`0000?ooooo00?o0000oooo
ooooool0;_ooool2o`0009gooooo000Yooooo`03o`000?oooooooooo01Oooooo0_l00009ooooo`03
o`000?oooooooooo00Gooooo00?o0000ooooooooool00_ooool00ol0003oooooooooo`0^ooooo`03
o`000?oooooooooo00Oooooo00?o0000ooooooooool01Oooool00ol0003oooooooooo`02ooooo`03
o`000?oooooooooo02oooooo00?o0000ooooooooool0Voooool002Wooooo00?o0000ooooooooool0
6?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Gooooo00Go0000oooooooooooo
ooooo`00000aooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool01Oooool00ol0003o
ooooooooo`02ooooo`03o`000?oooooooooo02oooooo00?o0000ooooooooool0Voooool002Wooooo
00?o0000ooooooooool06?ooool00ol0003oooooooooo`07ooooo`03o`000?oooooooooo00Cooooo
0_l00003ooooo`03o`000?oooooooooo02oooooo00?o0000ooooooooool02?ooool00ol0003ooooo
ooooo`04ooooo`05o`000?ooooooooooooooool00000<_ooool00ol0003oooooooooo`2Kooooo`00
:Oooool00ol0003oooooooooo`0Hooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0
1?ooool01Ol0003ooooooooooooooooo000003;ooooo0_l00009ooooo`03o`000?oooooooooo00Co
oooo00Go0000ooooooooooooooooo`00000booooo`03o`000?oooooooooo09_ooooo000Yooooo`03
o`000?oooooooooo01Sooooo0_l00009ooooo`03o`000?oooooooooo00?ooooo00Go0000oooooooo
ooooooooo`00000cooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool00_ooool2o`00
00;ooooo00?o0000ooooooooool0<Oooool00ol0003oooooooooo`2Kooooo`00:Oooool00ol0003o
ooooooooo`0Iooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool00oooool01?l0003o
ooooooooool0000dooooo`03o`000?oooooooooo00Sooooo00?o0000ooooooooool00_ooool01Ol0
003ooooooooooooooooo000003?ooooo00?o0000ooooooooool0Voooool002Wooooo00?o0000oooo
ooooool06Oooool00ol0003oooooooooo`08ooooo`04o`000?ooooooooooooooo`;o00000_ooool0
0ol0003oooooooooo`0booooo`03o`000?oooooooooo00Wooooo00Go0000ooooooooooooooooo`00
0002ooooo`03o`000?oooooooooo03;ooooo0_l0002Looooo`00:Oooool00ol0003oooooooooo`0I
ooooo`03o`000?oooooooooo00Wooooo00Co0000oooooooooooo00000_ooool00ol0003ooooooooo
o`0cooooo`;o00002_ooool00ol0003oooooooooo`02o`000003ooooool0003ooooo03Gooooo00?o
0000ooooooooool0V_ooool002Wooooo00?o0000ooooooooool06Oooool2o`0000_ooooo00?o0000
ooooool000000_l0000gooooo`03o`000?oooooooooo00Wooooo0ol000000ooooooo0000ooooo`0f
ooooo`03o`000?oooooooooo09[ooooo000Yooooo`03o`000?oooooooooo01[ooooo00?o0000oooo
ooooool02_ooool3o`0003Sooooo00?o0000ooooooooool02_ooool4o`0003Oooooo0_l0002Koooo
o`00:Oooool00ol0003oooooooooo`0Jooooo`03o`000?oooooooooo00[ooooo00?o0000oooooooo
ool0>?ooool00ol0003oooooooooo`0;ooooo`03o`000?oooooooooo03Sooooo00?o0000oooooooo
ool0VOooool002Wooooo00?o0000ooooooooool06_ooool00ol0003oooooooooo`0:ooooo`03o`00
0?oooooooooo03Sooooo0_l0000;ooooo`;o0000>_ooool00ol0003oooooooooo`2Iooooo`00:Ooo
ool00ol0003oooooooooo`0Jooooo`;o00002_ooool2o`0003_ooooo00?o0000ooooooooool02Ooo
ool00ol0003oooooooooo`0iooooo`;o0000V_ooool002Wooooo00?o0000ooooooooool06oooool0
0ol0003oooooooooo`08ooooo`03o`000?oooooooooo03[ooooo00?o0000ooooooooool02Oooool0
0ol0003oooooooooo`0jooooo`03o`000?oooooooooo09Sooooo000Yooooo`03o`000?oooooooooo
01_ooooo00?o0000ooooooooool02?ooool00ol0003oooooooooo`0jooooo`;o00002Oooool2o`00
03cooooo00?o0000ooooooooool0V?ooool002Wooooo00?o0000ooooooooool06oooool2o`0000So
oooo0_l0000mooooo`03o`000?oooooooooo00Oooooo00?o0000ooooooooool0>oooool2o`0009Wo
oooo000Yooooo`03o`000?oooooooooo01cooooo00?o0000ooooooooool01_ooool00ol0003ooooo
ooooo`0looooo`;o00002?ooool00ol0003oooooooooo`0looooo`03o`000?oooooooooo09Oooooo
000Yooooo`03o`000?oooooooooo01cooooo00?o0000ooooooooool01_ooool00ol0003ooooooooo
o`0mooooo`03o`000?oooooooooo00Gooooo0_l0000nooooo`;o0000V?ooool002Wooooo00?o0000
ooooooooool07?ooool2o`0000Kooooo0_l0000oooooo`;o00001_ooool00ol0003oooooooooo`0n
ooooo`03o`000?oooooooooo09Kooooo000Yooooo`03o`000?oooooooooo01gooooo0_l00005oooo
o`03o`000?oooooooooo03oooooo00?o0000ooooooooool00oooool2o`00043ooooo00?o0000oooo
ooooool01oooool00ol0003oooooooooo`06ooooo`Co00000_ooool3o`0000;ooooo00Go0000oooo
ool0003oooooo`000002ooooo`Co000000Goooooo`000?l0003o0000ooooo`02o`000003ooooool0
003o000000;o0000I?ooool002Wooooo00?o0000ooooooooool07_ooool2o`0000?ooooo0_l00011
ooooo`;o00000oooool2o`00047ooooo0_l00007ooooo`03o`000?oooooooooo00Kooooo00Co0000
oooooooooooo00000_ooool00ol0003oooooooooo`03ooooo`07o`000?oooooo0000ooooool0003o
ooooo`000002ooooo`05o`000?ooooooooooooooool000000_ooool00ol0003oooooo`000002oooo
o`03o`000?oooooooooo06?ooooo000Yooooo`03o`000?oooooooooo01oooooo1Ol00013ooooo`Ko
0000@_ooool4o`0000;ooooo0_l00004ooooo`Co000000Goooooo`000?ooooooooooo`000002oooo
o`Go000000Koooooo`000?oooooo0000ooooool00002ooooo`?o00000oooool01_l0003ooooooooo
ool0003oooooo`0000;ooooo00?o0000ooooooooool0Hoooool002Wooooo00?o0000ooooooooool0
7oooool4o`0004Cooooo1Ol00014ooooo`?o00001?ooool00ol0003oooooooooo`06ooooo`04o`00
0?ooooooooooo`0000;ooooo00go0000ooooooooooooooooo`000?oooooo0000ooooool0003ooooo
o`000?oooooo000000;ooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooo0000
00;ooooo00?o0000ooooooooool0Hoooool002Wooooo00?o0000ooooooooool0^?ooool00ol0003o
ooooooooo`06ooooo`?o00000oooool3o`0000;ooooo0_l000000ooooooo0000ooooo`02ooooo`;o
00000oooool4o`0000?ooooo0ol0001Uooooo`00:Oooool00ol0003oooooooooo`33ooooo`03o`00
0?oooooooooo01_ooooo00?o0000ooooooooool0Hoooool002Wooooo00?o0000ooooooooool0`_oo
ool2o`0001cooooo0_l0001Uooooo`00:Oooool00ol0003oooooooooo`3oooooodSooooo000Yoooo
o`03o`000?oooooooooo0?ooooooB?ooool002Wooooo00?o0000ooooooooool0oooooom8ooooo`00
:Oooool00ol0003oooooooooo`3oooooodSooooo000Yooooo`03o`000?oooooooooo0?ooooooB?oo
ool002Wooooo00?o0000ooooooooool0oooooom8ooooo`00:Oooool00ol0003oooooooooo`3ooooo
odSooooo000Yooooo`03o`000?oooooooooo0?ooooooB?ooool002Wooooo00?o0000ooooooooool0
oooooom8ooooo`00oooooomdooooo`00oooooomdooooo`00oooooomdooooo`00oooooomdooooo`00
oooooomdooooo`00oooooomdooooo`00oooooomdooooo`00oooooomdooooo`003_ooool3o`0000?o
oooo0ol00009ooooo`?o0000oooooomAooooo`003oooool00ol0003oooooooooo`03ooooo`03o`00
0?oooooooooo00Wooooo00?o0000ooooooooool00oooool00ol0003oooooooooo`3ooooood[ooooo
0002ooooo`Co00001?ooool2o`000003ooooool0003ooooo00?o00000oooool3o`0000;ooooo1Ol0
0003ooooo`03o`000?oooooooooo00?ooooo00?o0000ooooooooool00_ooool4o`0000;ooooo0ol0
0002ooooo`05o`000?oooooo0000ooooool000000_ooool4o`000005ooooool0003o0000o`000?oo
ool00_l000000ooooooo0000o`000002o`000?oooooo9Oooool000Kooooo00Co0000oooooooooooo
00000_ooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000;ooooo00Go0000
ooooooooooooooooo`000005ooooo`03o`000?oooooooooo00?ooooo00Go0000oooooooooooooooo
o`000002ooooo`04o`000?ooooooooooo`0000Gooooo00Oo0000ooooool0003oooooo`000?oooooo
000000;ooooo00Go0000ooooooooooooooooo`000002ooooo`03o`000?oooooo000000;ooooo00?o
0000ooooooooool0oooooolTooooo`000oooool3o`0000?ooooo00Co0000oooooooooooo00000_oo
ool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`0000?ooooo00?o0000oooooooo
ool00_ooool00ol0003oooooo`000004ooooo`05o`000?ooooooooooooooool000000_ooool00ol0
003oooooooooo`05o`000006ooooool0003oooooo`000?oooooo00000_ooool3o`0000?ooooo00Ko
0000oooooooooooo0000ooooool00002ooooo`03o`000?oooooooooo0?oooooo9?ooool000;ooooo
00?o0000ooooooooool01?ooool01?l0003oooooooooool00002ooooo`04o`000?ooooooooooo`00
00;ooooo00Co0000oooooooooooo00000oooool00ol0003oooooooooo`02ooooo`03o`000?oooooo
000000Gooooo00Co0000oooooooooooo00000_ooool01?l0003oooooooooool00003ooooo`09o`00
0?oooooo0000ooooool0003oooooo`000?oooooo000000;ooooo00Go0000ooooooooooooooooo`00
0002ooooo`03o`000?oooooo000000;ooooo00?o0000ooooooooool0oooooolTooooo`000oooool4
o`000004ooooool0003o0000ooooo`;o000000?oooooo`000?l000000_l00002ooooo`Co00001?oo
ool01?l0003oooooooooooooool2o`000003ooooool0003o000000Cooooo00Co0000oooooooooooo
oooo0ol00003ooooo`?o00000_ooool2o`000003ooooool0003ooooo00;ooooo0_l00003ooooo`Co
00000oooool3o`000?oooooo9_ooool001cooooo00?o0000ooooooooool02oooool00ol0003ooooo
ooooo`02ooooo`03o`000?oooooooooo01_ooooo00?o0000ooooooooool0oooooolTooooo`006_oo
ool3o`00017ooooo0_l0000Looooo`;o0000oooooolVooooo`00oooooomdooooo`00oooooomdoooo
o`00\
\>"],
  ImageRangeCache->{{{0, 370.812}, {228.812, 0}} -> {-6.78363, 4.64932, \
0.165449, 0.0270514}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
WindowToolbars->{},
CellGrouping->Manual,
WindowSize->{520, 365},
WindowMargins->{{4, Automatic}, {Automatic, 13}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 85, 2, 65, "Subtitle",
  Evaluatable->False],
Cell[1864, 57, 677, 15, 175, "Text",
  Evaluatable->False],
Cell[2544, 74, 58, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[2627, 79, 92, 2, 56, "Section",
  Evaluatable->False],
Cell[2722, 83, 152, 4, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2899, 91, 684, 16, 111, "Input"],
Cell[3586, 109, 46, 1, 27, "Output"],
Cell[3635, 112, 61, 1, 42, "Output"],
Cell[3699, 115, 1039, 19, 222, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[4775, 139, 129, 3, 27, "Input"],
Cell[4907, 144, 963, 16, 222, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[5907, 165, 208, 5, 52, "Input"],
Cell[6118, 172, 1115, 18, 253, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[7270, 195, 158, 3, 64, "Input"],
Cell[7431, 200, 935, 15, 245, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[8403, 220, 322, 7, 75, "Input"],
Cell[8728, 229, 40417, 1147, 183, 15735, 836, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False]
}, Closed]],

Cell[CellGroupData[{
Cell[49182, 1381, 184, 4, 43, "Input"],
Cell[49369, 1387, 52023, 1322, 214, 17029, 884, "GraphicsData", "PostScript", \
"Graphics",
  Evaluatable->False]
}, Closed]]
}, Closed]],
Cell[101419, 2713, 336, 9, 136, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[101780, 2726, 102, 2, 56, "Section",
  Evaluatable->False],
Cell[101885, 2730, 143, 4, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[102053, 2738, 416, 10, 43, "Input"],
Cell[102472, 2750, 59, 1, 27, "Output"],
Cell[102534, 2753, 716, 11, 127, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[103287, 2769, 207, 5, 60, "Input"],
Cell[103497, 2776, 757, 11, 163, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[104303, 2793, 102, 2, 36, "Section",
  Evaluatable->False],
Cell[104408, 2797, 140, 3, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[104573, 2804, 672, 16, 109, "Input"],
Cell[105248, 2822, 61, 1, 42, "Output"],
Cell[105312, 2825, 520, 9, 108, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[105869, 2839, 173, 5, 43, "Input"],
Cell[106045, 2846, 483, 7, 76, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[106565, 2858, 209, 5, 60, "Input"],
Cell[106777, 2865, 494, 8, 136, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[107308, 2878, 400, 9, 107, "Input"],
Cell[107711, 2889, 49139, 1054, 231, 10992, 577, "GraphicsData", \
"PostScript", "Graphics",
  Evaluatable->False],
Cell[156853, 3945, 130, 3, 27, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[157020, 3953, 189, 4, 59, "Input"],
Cell[157212, 3959, 61026, 1239, 238, 12530, 634, "GraphicsData", \
"PostScript", "Graphics",
  Evaluatable->False],
Cell[218241, 5200, 130, 3, 27, "Output"]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

